﻿//============================================
// filename: main.c
// chip    : CS8M320
// author  :
// date    : 2023-10-08
//============================================
#include "CS8M320.h"
#include "iap_deal.h"

unsigned char systime_base_1ms = 0;
unsigned int systime_count_500ms = 0;
unsigned char uart_read_temp = 0;

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
    if(TM0IF & TM0IE)
    {
        TM0IF = 0;
        systime_base_1ms = 1;
    }
    /*<!----------------- IAP所需程序 -----------------*/
    if(UR0_RNIF & UR0_RNIE)
    {
        UR0_RNIF = 0;
        uart_read_temp = UR0_RX_REG;
        iap_signal_detect(uart_read_temp);          //用户只需在接收到数据后调用此函数即可
    }
    /*<!----------------- IAP所需程序 -----------------*/
}

//============================================
// program start
//============================================
void main()
{
    iap_init();                           //IAP所需程序

    while(1)
    {
        asm("clrwdt");                              //IAP所需程序
        iap_reset_judge();                          //IAP所需程序 //在主循环中调用，当接收到升级握手指令后将会停止后续指令执行，等待看门狗复位

        if(systime_base_1ms)
        {
            systime_base_1ms = 0;
            if(++systime_count_500ms >= 500)
            {
                systime_count_500ms = 0;
                PT1 ^= 0b00100000;                  //每500ms翻转一次PT1.5口
            }
        }
    }
}
