﻿//============================================
// filename: main.c
// chip    : CS8M32x
// author  :
// date    : 2023-07-26
//============================================
#include "CS8M320.h"

/*-------------------------------SRAM_clear Demo例程介绍--------------------------
根据RAM空间分布，采用间接寻址的方式分别清零：
                       SRAM 0x080~0x0FF地址
                       SRAM PAGE0 0x100~0x1FF地址
                       SRAM PAGE1 0x100~0x167地址
---------------------------------------------------------------------------------*/

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{

}

//============================================
// program start
//============================================
void main()
{   
	GIE = 0;
	WORK = BSR;
	asm("push");
	BSR = 0b00000000;	//操作PAGE0前256Byte地址
	for(FSR0=0x80;FSR0!=0x00;FSR0++)	//清零bank0
	{
		IND0 = 0;
	}
	BSR = 0b10000000;	//操作PAGE0后256Byte地址
	FSR0=0x00;
	IND0 = 0;
	for(FSR0=0x01;FSR0!=0x00;FSR0++)	//清零bank1
	{
		IND0 = 0;
	}
	BSR = 0b10000001;	//操作PAGE1后256Byte地址
	for(FSR0=0x00;FSR0<=0x67;FSR0++)	//清零bank3
	{
		IND0 = 0;
	}
	asm("pop");
	BSR = WORK;
	GIE = 1;
	while(1);
}
