﻿//============================================
// filename: main.c
// chip    : CS8M32x
// author  :
// date    : 2023-07-27
//============================================
#include "CS8M320.h"
#include "adc.h"
#include "uart.h"
#include "timer0.h"

/*-------------------------------ADC Demo例程介绍-------------------------------
用户可在adc_get_result(SIG_AIN3)函数中修改测试模式mode
（1）mode = 0，以VDD为参考电压，测AIN3外部输入电压
（2）mode = 1，以PT3.0外灌电压为参考电压，测AIN3外部输入电压
（3）mode = 2，以内部1.22V为参考电压，测AIN3外部输入电压
（4）mode = 3, 以VDD为参考电压，测内部1.22V
主循环中循环进行ADC采样
每400ms通过UART TX_PT3.1打印一次ADC码值
---------------------------------------------------------------------------------*/

unsigned char systime_cnt = 0;
unsigned char systime_flag = 0;
unsigned int adc_samp_result = 0;
unsigned char uart_trans_1byte_ok = 1;
unsigned char temp = 0;

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(TM0IF && TM0IE)    //4ms中断
	{
		TM0IF = 0;
		if(++systime_cnt >= 100)
		{
			systime_cnt = 0;
			systime_flag = 1;    //400ms时基标志
		}
	}
	else if(UR0IF)
	{
		if(UR0_TEIF && UR0_TEIE)		//发送中断表示发送FIFO数据已取走为空，可向其写入数据，但串口仍处于发送数据状态，需判断TX_BUSY为0方可进入休眠
		{
			UR0_TEIF = 0;
			uart_trans_1byte_ok = 1;
		}
	}
}

//============================================
// program start
//============================================
void main()
{
	PT3CON_0 = 1;
	PT5EN_3 = 1;
	PT3EN_3 = 0;	//PT3.3为模拟输入口
	PT3PU_3 = 0;
	PT3CON_3 = 1;
	timer0_init();
	adc_init();
	uart_init();		//波特率为38400，PT3.2为RX，PT3.1为TX
	while(1)
	{
		adc_samp_result = adc_get_result(SIG_AIN3);
		if(systime_flag)
		{
			systime_flag = 0;
			uart();
		}	
	}
}
