//==============================================
// Date:2023-10-09
// Version: V1.0.0 
//==============================================

//Data Memory Organization 00h-08h
volatile unsigned char IND0             @ 0x00;     //{ [7:0] }
volatile unsigned char IND1             @ 0x01;     //{ [7:0] }
volatile unsigned char FSR0             @ 0x02;     //{ [7:0] }
volatile unsigned char FSR1             @ 0x03;     //{ [7:0] }
volatile unsigned char STATUS           @ 0x04;     //{ 0, 0, 0, PD, TO, DC, C, Z }
volatile unsigned char WORK             @ 0x05;     //{ [7:0] }
volatile unsigned char INTF             @ 0x06;     //{ BRKIF, TM2IF, CAPIF, TM0IF, SRADIF, 0, E1IF, E0IF }
volatile unsigned char INTE             @ 0x07;     //{ GIE, TM2IE, CAPIE, TM0IE, SRADIE, 0, E1IE, E0IE }
volatile unsigned char BSR              @ 0x08;     //{ IRP0, IRP1, 0, 0, 0, 0, 0, PAGE[0:0] }

//Peripheral special registers 09h-7Ch
volatile unsigned char RSTSR            @ 0x09;     //{ 0, 0, 0, 0, 0, EMCF, ILOPF, 0 }
volatile unsigned char EADRH            @ 0x0A;     //{ EADR[15:8] }
volatile unsigned char EADRL            @ 0x0B;     //{ EADR[7:0] }
volatile unsigned char EDATH            @ 0x0C;     //{ EDATH[7:0] }
volatile unsigned char WDTCON           @ 0x0D;     //{ WDTEN, 0, 0, 0, 0, WTS[2:0] }
volatile unsigned char WDTIN            @ 0x0E;     //{ WDTIN[7:0] }
volatile unsigned char TM0CON           @ 0x0F;     //{ T0EN, T0RATE[2:0], 0, T0RSTB, T0SEL[1:0] }
volatile unsigned char TM0IN            @ 0x10;     //{ TM0IN[7:0] }
volatile unsigned char TM0CNT           @ 0x11;     //{ TM0CNT[7:0] }
volatile unsigned char PAGECTL          @ 0x14;     //{ 0, 0, 0, 0, 0, 0, 0, PAGE2 }
volatile unsigned char TM2CAP           @ 0x15;     //{ CAPEN, CAPCCP[1:0], CNTCLR, CAPSEL[1:0], BRKEN, BRKPOL }
volatile unsigned char MCK              @ 0x16;     //{ 0, 0, CST_WDT, 0, 0, MODE_EN, 0, LVRES_EN }
volatile unsigned char TM2CON           @ 0x17;     //{ T2EN, T2RATE[2:0], T2CKS, T2RSTB, T2OUT, PWM2OUT }
volatile unsigned char TM2IN            @ 0x18;     //{ TM2IN[7:0] }
volatile unsigned char TM2CNT           @ 0x19;     //{ TM2CNT[7:0] }
volatile unsigned char TM2R             @ 0x1A;     //{ TM2R[7:0] }
volatile unsigned char TM3CON           @ 0x1B;     //{ T3EN, T3RATE[2:0], RSV, T3RSTB, T3OUT, PWM3OUT }
volatile unsigned char TM3IN            @ 0x1C;     //{ TM3IN[7:0] }
volatile unsigned char TM3CNT           @ 0x1D;     //{ TM3CNT[7:0] }
volatile unsigned char TM3R1            @ 0x1E;     //{ TM3R1[7:0] }
volatile unsigned char TM3INH           @ 0x1F;     //{ 0, 0, 0, 0, TM3INH[11:8] }
volatile unsigned char PT1              @ 0x20;     //{ 0, 0, PT1[5:3], 0, 0, PT1[0:0] }
volatile unsigned char PT1EN            @ 0x21;     //{ 0, 0, PT1EN[5:3], 0, 0, PT1EN[0:0] }
volatile unsigned char PT1PU            @ 0x22;     //{ 0, 0, PT1PU[5:3], 0, 0, PT1PU[0:0] }
volatile unsigned char PT1CON           @ 0x23;     //{ 0, 0, PT1W[2:0], E1M, E0M[1:0] }
volatile unsigned char TM2INH           @ 0x24;     //{ 0, 0, 0, 0, TM2IN[11:8] }
volatile unsigned char TM2CNTH          @ 0x25;     //{ TM3CNT_DT1[2:0], 0, TM2CNT[11:8] }
volatile unsigned char TM2RH            @ 0x26;     //{ TM3CNT_DT2[2:0], 0, TM2R[11:8] }
volatile unsigned char TM3CNTH          @ 0x27;     //{ TM3CNT_DT3[2:0], 0, TM3CNT[11:8] }
volatile unsigned char PT3              @ 0x28;     //{ PT3VTH[1:1], PT3[6:0] }
volatile unsigned char PT3EN            @ 0x29;     //{ PT3VTH[2:2], PT3EN[6:0] }
volatile unsigned char PT3PU            @ 0x2A;     //{ PT3VTH[3:3], PT3PU[6:0] }
volatile unsigned char PT3CON           @ 0x2B;     //{ 0, PT3CON[6:0] }
volatile unsigned char TM3R3            @ 0x2C;     //{ TM3R3[7:0] }
volatile unsigned char TM3CON2          @ 0x2D;     //{ DT3CK[1:0], DT3CNT[2:0], DT3_EN, P3H1OEN, P3L1OEN }
volatile unsigned char CONFIG1          @ 0x2E;     //{ P3H1INV, P3L1INV, 0, PWM3STALL, PWM2STALL, PWM2PO, PWM3PO1, 0 }
volatile unsigned char CONFIG2          @ 0x2F;     //{ VTHSEL, PWM3MD, PWM3NUM, PWM3WV, 0, 0, PWM3PO3, PWM3PO2 }
volatile unsigned char PT5              @ 0x30;     //{ PT5[7:5], 0, PT5[3:0] }
volatile unsigned char PT5EN            @ 0x31;     //{ PT5EN[7:5], 0, PT5EN[3:0] }
volatile unsigned char PT5PU            @ 0x32;     //{ PT5PU[7:5], PT1PD[3:3], PT5PU[3:0] }
volatile unsigned char PT5CON           @ 0x33;     //{ PT5CON[7:5], 0, PT5CON[3:0] }
volatile unsigned char SRADCON0         @ 0x34;     //{ ADC2V_EN, SARVCMSEL, SRADACKS[1:0], 0, 0, SRADCKS[1:0] }
volatile unsigned char SRADCON1         @ 0x35;     //{ SRADEN, SRADS, OFTEN, CALIF, ENOV, OFFEX, VREFS[1:0] }
volatile unsigned char SRADCON2         @ 0x36;     //{ CHS[3:0], 0, 0, 0, SAR_DIFFEN }
volatile unsigned char SRADL            @ 0x37;     //{ SRAD[7:0] }
volatile unsigned char SRADH            @ 0x38;     //{ 0, 0, 0, 0, SRAD[11:8] }
volatile unsigned char SROFTL           @ 0x39;     //{ SROFT[7:0] }
volatile unsigned char SROFTH           @ 0x3A;     //{ 0, 0, 0, 0, SROFT[11:8] }
volatile unsigned char TM3R2            @ 0x3B;     //{ TM3R2[7:0] }
volatile unsigned char INTF2            @ 0x3C;     //{ 0, 0, LVRES_IF, TM3IF, 0, LVDIF, I2CIF, UR0IF }
volatile unsigned char INTE2            @ 0x3D;     //{ 0, 0, LVRES_IE, TM3IE, 0, LVDIE, 0, 0 }
volatile unsigned char INTCFG           @ 0x40;     //{ INTCFG[7:0] }
volatile unsigned char PT1CON1          @ 0x41;     //{ 0, 0, 0, 0, 0, 0, 0, PT1CON[0:0] }
volatile unsigned char PT5CON1          @ 0x42;     //{ PT5W[7:5], 0, 0, 0, 0, 0 }
volatile unsigned char TM3CON3          @ 0x45;     //{ P3H3INV, P3L3INV, P3H3OEN, P3L3OEN, P3H2INV, P3L2INV, P3H2OEN, P3L2OEN }
volatile unsigned char UR0_CR1          @ 0x50;     //{ TX9D, RX9D, TX9_EN, RX9_EN, RX_EN, TX_EN, UART0_SEL, UART0_EN }
volatile unsigned char UR0_BRR0         @ 0x51;     //{ BRR0[7:0] }
volatile unsigned char UR0_BRR1         @ 0x52;     //{ 0, UARTDIV[2:0], BRR1[3:0] }
volatile unsigned char UR0_TX_REG       @ 0x53;     //{ TX_REG[7:0] }
volatile unsigned char UR0_RX_REG       @ 0x54;     //{ RX_REG[7:0] }
volatile unsigned char UR0_ST           @ 0x55;     //{ UR_TINV, UR_RINV, UR_SWAP, TXFIFO_EMPTY, RX_BUSY, TX_BUSY, RX_OV_ERR, STOP_ERR }
volatile unsigned char UR0_INTF         @ 0x56;     //{ 0, 0, 0, UR0ERRIF, UR0_RHIF, UR0_RNIF, UR0WK_IF, UR0_TEIF }
volatile unsigned char UR0_INTE         @ 0x57;     //{ 0, 0, 0, UR0ERRIE, UR0_RHIE, UR0_RNIE, UR0WK_IE, UR0_TEIE }
volatile unsigned char I2CCON           @ 0x59;     //{ I2C_EN, AWK_EN, CST_EN, ACK_EN, I2CSTUS[3:0] }
volatile unsigned char I2CCON1          @ 0x5A;     //{ I2C_SEL, 0, 0, 0, 0, 0, I2C_DIV[1:0] }
volatile unsigned char I2CDAT           @ 0x5B;     //{ I2CDAT[7:0] }
volatile unsigned char I2CADR           @ 0x5C;     //{ I2CADR[6:0], GC_EN }
volatile unsigned char I2C_INTF         @ 0x5D;     //{ I2C_TIF, I2C_RIF, I2C_STIF, 0, 0, 0, 0, 0 }
volatile unsigned char I2C_INTE         @ 0x5E;     //{ I2C_TIE, I2C_RIE, I2C_STIE, 0, 0, 0, 0, 0 }
volatile unsigned char ISPCON1          @ 0x60;     //{ 0, ISPWDTRF, 0, 0, 0, 0, 0, ISPOF }
volatile unsigned char WRPRT            @ 0x63;     //{ 0, 0, 0, 0, 0, 0, 0, WRPRTF }
volatile unsigned char TBLPEN           @ 0x77;     //{ TBLPEN[7:0] }
volatile unsigned char METCH            @ 0x79;     //{ 0, 0, 0, 0, METCH3, MCK1[1:0], METCH0 }
volatile unsigned char CONFLASH         @ 0x7C;     //{ 0, 0, CONFLASH[5:0] }
volatile unsigned char TESTOP           @ 0x7E;     //{ 0, 0, 0, 0, TMOD[3:0] }
volatile unsigned char TEST             @ 0x7F;     //{ TEST[7:0] }

//-------------------------------------------------------
//  STATUS register bit map
//-------------------------------------------------------
volatile sbit Z                         @ 0x04*8+0;
volatile sbit C                         @ 0x04*8+1;
volatile sbit DC                        @ 0x04*8+2;
volatile sbit TO                        @ 0x04*8+3;
volatile sbit PD                        @ 0x04*8+4;

//-------------------------------------------------------
//  INTF register bit map
//-------------------------------------------------------
volatile sbit E0IF                      @ 0x06*8+0;
volatile sbit E1IF                      @ 0x06*8+1;
volatile sbit SRADIF                    @ 0x06*8+3;
volatile sbit TM0IF                     @ 0x06*8+4;
volatile sbit CAPIF                     @ 0x06*8+5;
volatile sbit TM2IF                     @ 0x06*8+6;
volatile sbit BRKIF                     @ 0x06*8+7;

//-------------------------------------------------------
//  INTE register bit map
//-------------------------------------------------------
volatile sbit E0IE                      @ 0x07*8+0;
volatile sbit E1IE                      @ 0x07*8+1;
volatile sbit SRADIE                    @ 0x07*8+3;
volatile sbit TM0IE                     @ 0x07*8+4;
volatile sbit CAPIE                     @ 0x07*8+5;
volatile sbit TM2IE                     @ 0x07*8+6;
volatile sbit GIE                       @ 0x07*8+7;

//-------------------------------------------------------
//  BSR register bit map
//-------------------------------------------------------
volatile sbit PAGE_0                    @ 0x08*8+0;
volatile sbit IRP1                      @ 0x08*8+6;
volatile sbit IRP0                      @ 0x08*8+7;

//-------------------------------------------------------
//  RSTSR register bit map
//-------------------------------------------------------
volatile sbit ILOPF                     @ 0x09*8+1;
volatile sbit EMCF                      @ 0x09*8+2;

//-------------------------------------------------------
//  EADRH register bit map
//-------------------------------------------------------
volatile sbit EADR_8                    @ 0x0A*8+0;
volatile sbit EADR_9                    @ 0x0A*8+1;
volatile sbit EADR_10                   @ 0x0A*8+2;
volatile sbit EADR_11                   @ 0x0A*8+3;
volatile sbit EADR_12                   @ 0x0A*8+4;
volatile sbit EADR_13                   @ 0x0A*8+5;
volatile sbit EADR_14                   @ 0x0A*8+6;
volatile sbit EADR_15                   @ 0x0A*8+7;

//-------------------------------------------------------
//  EADRL register bit map
//-------------------------------------------------------
volatile sbit EADR_0                    @ 0x0B*8+0;
volatile sbit EADR_1                    @ 0x0B*8+1;
volatile sbit EADR_2                    @ 0x0B*8+2;
volatile sbit EADR_3                    @ 0x0B*8+3;
volatile sbit EADR_4                    @ 0x0B*8+4;
volatile sbit EADR_5                    @ 0x0B*8+5;
volatile sbit EADR_6                    @ 0x0B*8+6;
volatile sbit EADR_7                    @ 0x0B*8+7;

//-------------------------------------------------------
//  EDATH register bit map
//-------------------------------------------------------
volatile sbit EDATH_0                   @ 0x0C*8+0;
volatile sbit EDATH_1                   @ 0x0C*8+1;
volatile sbit EDATH_2                   @ 0x0C*8+2;
volatile sbit EDATH_3                   @ 0x0C*8+3;
volatile sbit EDATH_4                   @ 0x0C*8+4;
volatile sbit EDATH_5                   @ 0x0C*8+5;
volatile sbit EDATH_6                   @ 0x0C*8+6;
volatile sbit EDATH_7                   @ 0x0C*8+7;

//-------------------------------------------------------
//  WDTCON register bit map
//-------------------------------------------------------
volatile sbit WTS_0                     @ 0x0D*8+0;
volatile sbit WTS_1                     @ 0x0D*8+1;
volatile sbit WTS_2                     @ 0x0D*8+2;
volatile sbit WDTEN                     @ 0x0D*8+7;

//-------------------------------------------------------
//  WDTIN register bit map
//-------------------------------------------------------
volatile sbit WDTIN_0                   @ 0x0E*8+0;
volatile sbit WDTIN_1                   @ 0x0E*8+1;
volatile sbit WDTIN_2                   @ 0x0E*8+2;
volatile sbit WDTIN_3                   @ 0x0E*8+3;
volatile sbit WDTIN_4                   @ 0x0E*8+4;
volatile sbit WDTIN_5                   @ 0x0E*8+5;
volatile sbit WDTIN_6                   @ 0x0E*8+6;
volatile sbit WDTIN_7                   @ 0x0E*8+7;

//-------------------------------------------------------
//  TM0CON register bit map
//-------------------------------------------------------
volatile sbit T0SEL_0                   @ 0x0F*8+0;
volatile sbit T0SEL_1                   @ 0x0F*8+1;
volatile sbit T0RSTB                    @ 0x0F*8+2;
volatile sbit T0RATE_0                  @ 0x0F*8+4;
volatile sbit T0RATE_1                  @ 0x0F*8+5;
volatile sbit T0RATE_2                  @ 0x0F*8+6;
volatile sbit T0EN                      @ 0x0F*8+7;

//-------------------------------------------------------
//  TM0IN register bit map
//-------------------------------------------------------
volatile sbit TM0IN_0                   @ 0x10*8+0;
volatile sbit TM0IN_1                   @ 0x10*8+1;
volatile sbit TM0IN_2                   @ 0x10*8+2;
volatile sbit TM0IN_3                   @ 0x10*8+3;
volatile sbit TM0IN_4                   @ 0x10*8+4;
volatile sbit TM0IN_5                   @ 0x10*8+5;
volatile sbit TM0IN_6                   @ 0x10*8+6;
volatile sbit TM0IN_7                   @ 0x10*8+7;

//-------------------------------------------------------
//  TM0CNT register bit map
//-------------------------------------------------------
volatile sbit TM0CNT_0                  @ 0x11*8+0;
volatile sbit TM0CNT_1                  @ 0x11*8+1;
volatile sbit TM0CNT_2                  @ 0x11*8+2;
volatile sbit TM0CNT_3                  @ 0x11*8+3;
volatile sbit TM0CNT_4                  @ 0x11*8+4;
volatile sbit TM0CNT_5                  @ 0x11*8+5;
volatile sbit TM0CNT_6                  @ 0x11*8+6;
volatile sbit TM0CNT_7                  @ 0x11*8+7;

//-------------------------------------------------------
//  PAGECTL register bit map
//-------------------------------------------------------
volatile sbit PAGE2                     @ 0x14*8+0;

//-------------------------------------------------------
//  TM2CAP register bit map
//-------------------------------------------------------
volatile sbit BRKPOL                    @ 0x15*8+0;
volatile sbit BRKEN                     @ 0x15*8+1;
volatile sbit CAPSEL_0                  @ 0x15*8+2;
volatile sbit CAPSEL_1                  @ 0x15*8+3;
volatile sbit CNTCLR                    @ 0x15*8+4;
volatile sbit CAPCCP_0                  @ 0x15*8+5;
volatile sbit CAPCCP_1                  @ 0x15*8+6;
volatile sbit CAPEN                     @ 0x15*8+7;

//-------------------------------------------------------
//  MCK register bit map
//-------------------------------------------------------
volatile sbit LVRES_EN                  @ 0x16*8+0;
volatile sbit MODE_EN                   @ 0x16*8+2;
volatile sbit CST_WDT                   @ 0x16*8+5;

//-------------------------------------------------------
//  TM2CON register bit map
//-------------------------------------------------------
volatile sbit PWM2OUT                   @ 0x17*8+0;
volatile sbit T2OUT                     @ 0x17*8+1;
volatile sbit T2RSTB                    @ 0x17*8+2;
volatile sbit T2CKS                     @ 0x17*8+3;
volatile sbit T2RATE_0                  @ 0x17*8+4;
volatile sbit T2RATE_1                  @ 0x17*8+5;
volatile sbit T2RATE_2                  @ 0x17*8+6;
volatile sbit T2EN                      @ 0x17*8+7;

//-------------------------------------------------------
//  TM2IN register bit map
//-------------------------------------------------------
volatile sbit TM2IN_0                   @ 0x18*8+0;
volatile sbit TM2IN_1                   @ 0x18*8+1;
volatile sbit TM2IN_2                   @ 0x18*8+2;
volatile sbit TM2IN_3                   @ 0x18*8+3;
volatile sbit TM2IN_4                   @ 0x18*8+4;
volatile sbit TM2IN_5                   @ 0x18*8+5;
volatile sbit TM2IN_6                   @ 0x18*8+6;
volatile sbit TM2IN_7                   @ 0x18*8+7;

//-------------------------------------------------------
//  TM2CNT register bit map
//-------------------------------------------------------
volatile sbit TM2CNT_0                  @ 0x19*8+0;
volatile sbit TM2CNT_1                  @ 0x19*8+1;
volatile sbit TM2CNT_2                  @ 0x19*8+2;
volatile sbit TM2CNT_3                  @ 0x19*8+3;
volatile sbit TM2CNT_4                  @ 0x19*8+4;
volatile sbit TM2CNT_5                  @ 0x19*8+5;
volatile sbit TM2CNT_6                  @ 0x19*8+6;
volatile sbit TM2CNT_7                  @ 0x19*8+7;

//-------------------------------------------------------
//  TM2R register bit map
//-------------------------------------------------------
volatile sbit TM2R_0                    @ 0x1A*8+0;
volatile sbit TM2R_1                    @ 0x1A*8+1;
volatile sbit TM2R_2                    @ 0x1A*8+2;
volatile sbit TM2R_3                    @ 0x1A*8+3;
volatile sbit TM2R_4                    @ 0x1A*8+4;
volatile sbit TM2R_5                    @ 0x1A*8+5;
volatile sbit TM2R_6                    @ 0x1A*8+6;
volatile sbit TM2R_7                    @ 0x1A*8+7;

//-------------------------------------------------------
//  TM3CON register bit map
//-------------------------------------------------------
volatile sbit PWM3OUT                   @ 0x1B*8+0;
volatile sbit T3OUT                     @ 0x1B*8+1;
volatile sbit T3RSTB                    @ 0x1B*8+2;
volatile sbit RSV                       @ 0x1B*8+3;
volatile sbit T3RATE_0                  @ 0x1B*8+4;
volatile sbit T3RATE_1                  @ 0x1B*8+5;
volatile sbit T3RATE_2                  @ 0x1B*8+6;
volatile sbit T3EN                      @ 0x1B*8+7;

//-------------------------------------------------------
//  TM3IN register bit map
//-------------------------------------------------------
volatile sbit TM3IN_0                   @ 0x1C*8+0;
volatile sbit TM3IN_1                   @ 0x1C*8+1;
volatile sbit TM3IN_2                   @ 0x1C*8+2;
volatile sbit TM3IN_3                   @ 0x1C*8+3;
volatile sbit TM3IN_4                   @ 0x1C*8+4;
volatile sbit TM3IN_5                   @ 0x1C*8+5;
volatile sbit TM3IN_6                   @ 0x1C*8+6;
volatile sbit TM3IN_7                   @ 0x1C*8+7;

//-------------------------------------------------------
//  TM3CNT register bit map
//-------------------------------------------------------
volatile sbit TM3CNT_0                  @ 0x1D*8+0;
volatile sbit TM3CNT_1                  @ 0x1D*8+1;
volatile sbit TM3CNT_2                  @ 0x1D*8+2;
volatile sbit TM3CNT_3                  @ 0x1D*8+3;
volatile sbit TM3CNT_4                  @ 0x1D*8+4;
volatile sbit TM3CNT_5                  @ 0x1D*8+5;
volatile sbit TM3CNT_6                  @ 0x1D*8+6;
volatile sbit TM3CNT_7                  @ 0x1D*8+7;

//-------------------------------------------------------
//  TM3R1 register bit map
//-------------------------------------------------------
volatile sbit TM3R1_0                   @ 0x1E*8+0;
volatile sbit TM3R1_1                   @ 0x1E*8+1;
volatile sbit TM3R1_2                   @ 0x1E*8+2;
volatile sbit TM3R1_3                   @ 0x1E*8+3;
volatile sbit TM3R1_4                   @ 0x1E*8+4;
volatile sbit TM3R1_5                   @ 0x1E*8+5;
volatile sbit TM3R1_6                   @ 0x1E*8+6;
volatile sbit TM3R1_7                   @ 0x1E*8+7;

//-------------------------------------------------------
//  TM3INH register bit map
//-------------------------------------------------------
volatile sbit TM3INH_8                  @ 0x1F*8+0;
volatile sbit TM3INH_9                  @ 0x1F*8+1;
volatile sbit TM3INH_10                 @ 0x1F*8+2;
volatile sbit TM3INH_11                 @ 0x1F*8+3;

//-------------------------------------------------------
//  PT1 register bit map
//-------------------------------------------------------
volatile sbit PT1_0                     @ 0x20*8+0;
volatile sbit PT1_3                     @ 0x20*8+3;
volatile sbit PT1_4                     @ 0x20*8+4;
volatile sbit PT1_5                     @ 0x20*8+5;

//-------------------------------------------------------
//  PT1EN register bit map
//-------------------------------------------------------
volatile sbit PT1EN_0                   @ 0x21*8+0;
volatile sbit PT1EN_3                   @ 0x21*8+3;
volatile sbit PT1EN_4                   @ 0x21*8+4;
volatile sbit PT1EN_5                   @ 0x21*8+5;

//-------------------------------------------------------
//  PT1PU register bit map
//-------------------------------------------------------
volatile sbit PT1PU_0                   @ 0x22*8+0;
volatile sbit PT1PU_3                   @ 0x22*8+3;
volatile sbit PT1PU_4                   @ 0x22*8+4;
volatile sbit PT1PU_5                   @ 0x22*8+5;

//-------------------------------------------------------
//  PT1CON register bit map
//-------------------------------------------------------
volatile sbit E0M_0                     @ 0x23*8+0;
volatile sbit E0M_1                     @ 0x23*8+1;
volatile sbit E1M                       @ 0x23*8+2;
volatile sbit PT1W_0                    @ 0x23*8+3;
volatile sbit PT1W_1                    @ 0x23*8+4;
volatile sbit PT1W_2                    @ 0x23*8+5;

//-------------------------------------------------------
//  TM2INH register bit map
//-------------------------------------------------------
volatile sbit TM2IN_8                   @ 0x24*8+0;
volatile sbit TM2IN_9                   @ 0x24*8+1;
volatile sbit TM2IN_10                  @ 0x24*8+2;
volatile sbit TM2IN_11                  @ 0x24*8+3;

//-------------------------------------------------------
//  TM2CNTH register bit map
//-------------------------------------------------------
volatile sbit TM2CNT_8                  @ 0x25*8+0;
volatile sbit TM2CNT_9                  @ 0x25*8+1;
volatile sbit TM2CNT_10                 @ 0x25*8+2;
volatile sbit TM2CNT_11                 @ 0x25*8+3;
volatile sbit TM3CNT_DT1_0                @ 0x25*8+5;
volatile sbit TM3CNT_DT1_1                @ 0x25*8+6;
volatile sbit TM3CNT_DT1_2                @ 0x25*8+7;

//-------------------------------------------------------
//  TM2RH register bit map
//-------------------------------------------------------
volatile sbit TM2R_8                    @ 0x26*8+0;
volatile sbit TM2R_9                    @ 0x26*8+1;
volatile sbit TM2R_10                   @ 0x26*8+2;
volatile sbit TM2R_11                   @ 0x26*8+3;
volatile sbit TM3CNT_DT2_0                @ 0x26*8+5;
volatile sbit TM3CNT_DT2_1                @ 0x26*8+6;
volatile sbit TM3CNT_DT2_2                @ 0x26*8+7;

//-------------------------------------------------------
//  TM3CNTH register bit map
//-------------------------------------------------------
volatile sbit TM3CNT_8                  @ 0x27*8+0;
volatile sbit TM3CNT_9                  @ 0x27*8+1;
volatile sbit TM3CNT_10                 @ 0x27*8+2;
volatile sbit TM3CNT_11                 @ 0x27*8+3;
volatile sbit TM3CNT_DT3_0                @ 0x27*8+5;
volatile sbit TM3CNT_DT3_1                @ 0x27*8+6;
volatile sbit TM3CNT_DT3_2                @ 0x27*8+7;

//-------------------------------------------------------
//  PT3 register bit map
//-------------------------------------------------------
volatile sbit PT3_0                     @ 0x28*8+0;
volatile sbit PT3_1                     @ 0x28*8+1;
volatile sbit PT3_2                     @ 0x28*8+2;
volatile sbit PT3_3                     @ 0x28*8+3;
volatile sbit PT3_4                     @ 0x28*8+4;
volatile sbit PT3_5                     @ 0x28*8+5;
volatile sbit PT3_6                     @ 0x28*8+6;
volatile sbit PT3VTH_1                  @ 0x28*8+7;

//-------------------------------------------------------
//  PT3EN register bit map
//-------------------------------------------------------
volatile sbit PT3EN_0                   @ 0x29*8+0;
volatile sbit PT3EN_1                   @ 0x29*8+1;
volatile sbit PT3EN_2                   @ 0x29*8+2;
volatile sbit PT3EN_3                   @ 0x29*8+3;
volatile sbit PT3EN_4                   @ 0x29*8+4;
volatile sbit PT3EN_5                   @ 0x29*8+5;
volatile sbit PT3EN_6                   @ 0x29*8+6;
volatile sbit PT3VTH_2                  @ 0x29*8+7;

//-------------------------------------------------------
//  PT3PU register bit map
//-------------------------------------------------------
volatile sbit PT3PU_0                   @ 0x2A*8+0;
volatile sbit PT3PU_1                   @ 0x2A*8+1;
volatile sbit PT3PU_2                   @ 0x2A*8+2;
volatile sbit PT3PU_3                   @ 0x2A*8+3;
volatile sbit PT3PU_4                   @ 0x2A*8+4;
volatile sbit PT3PU_5                   @ 0x2A*8+5;
volatile sbit PT3PU_6                   @ 0x2A*8+6;
volatile sbit PT3VTH_3                  @ 0x2A*8+7;

//-------------------------------------------------------
//  PT3CON register bit map
//-------------------------------------------------------
volatile sbit PT3CON_0                  @ 0x2B*8+0;
volatile sbit PT3CON_1                  @ 0x2B*8+1;
volatile sbit PT3CON_2                  @ 0x2B*8+2;
volatile sbit PT3CON_3                  @ 0x2B*8+3;
volatile sbit PT3CON_4                  @ 0x2B*8+4;
volatile sbit PT3CON_5                  @ 0x2B*8+5;
volatile sbit PT3CON_6                  @ 0x2B*8+6;

//-------------------------------------------------------
//  TM3R3 register bit map
//-------------------------------------------------------
volatile sbit TM3R3_0                   @ 0x2C*8+0;
volatile sbit TM3R3_1                   @ 0x2C*8+1;
volatile sbit TM3R3_2                   @ 0x2C*8+2;
volatile sbit TM3R3_3                   @ 0x2C*8+3;
volatile sbit TM3R3_4                   @ 0x2C*8+4;
volatile sbit TM3R3_5                   @ 0x2C*8+5;
volatile sbit TM3R3_6                   @ 0x2C*8+6;
volatile sbit TM3R3_7                   @ 0x2C*8+7;

//-------------------------------------------------------
//  TM3CON2 register bit map
//-------------------------------------------------------
volatile sbit P3L1OEN                   @ 0x2D*8+0;
volatile sbit P3H1OEN                   @ 0x2D*8+1;
volatile sbit DT3_EN                    @ 0x2D*8+2;
volatile sbit DT3CNT_0                  @ 0x2D*8+3;
volatile sbit DT3CNT_1                  @ 0x2D*8+4;
volatile sbit DT3CNT_2                  @ 0x2D*8+5;
volatile sbit DT3CK_0                   @ 0x2D*8+6;
volatile sbit DT3CK_1                   @ 0x2D*8+7;

//-------------------------------------------------------
//  CONFIG1 register bit map
//-------------------------------------------------------
volatile sbit PWM3PO1                   @ 0x2E*8+1;
volatile sbit PWM2PO                    @ 0x2E*8+2;
volatile sbit PWM2STALL                 @ 0x2E*8+3;
volatile sbit PWM3STALL                 @ 0x2E*8+4;
volatile sbit P3L1INV                   @ 0x2E*8+6;
volatile sbit P3H1INV                   @ 0x2E*8+7;

//-------------------------------------------------------
//  CONFIG2 register bit map
//-------------------------------------------------------
volatile sbit PWM3PO2                   @ 0x2F*8+0;
volatile sbit PWM3PO3                   @ 0x2F*8+1;
volatile sbit PWM3WV                    @ 0x2F*8+4;
volatile sbit PWM3NUM                   @ 0x2F*8+5;
volatile sbit PWM3MD                    @ 0x2F*8+6;
volatile sbit VTHSEL                    @ 0x2F*8+7;

//-------------------------------------------------------
//  PT5 register bit map
//-------------------------------------------------------
volatile sbit PT5_0                     @ 0x30*8+0;
volatile sbit PT5_1                     @ 0x30*8+1;
volatile sbit PT5_2                     @ 0x30*8+2;
volatile sbit PT5_3                     @ 0x30*8+3;
volatile sbit PT5_5                     @ 0x30*8+5;
volatile sbit PT5_6                     @ 0x30*8+6;
volatile sbit PT5_7                     @ 0x30*8+7;

//-------------------------------------------------------
//  PT5EN register bit map
//-------------------------------------------------------
volatile sbit PT5EN_0                   @ 0x31*8+0;
volatile sbit PT5EN_1                   @ 0x31*8+1;
volatile sbit PT5EN_2                   @ 0x31*8+2;
volatile sbit PT5EN_3                   @ 0x31*8+3;
volatile sbit PT5EN_5                   @ 0x31*8+5;
volatile sbit PT5EN_6                   @ 0x31*8+6;
volatile sbit PT5EN_7                   @ 0x31*8+7;

//-------------------------------------------------------
//  PT5PU register bit map
//-------------------------------------------------------
volatile sbit PT5PU_0                   @ 0x32*8+0;
volatile sbit PT5PU_1                   @ 0x32*8+1;
volatile sbit PT5PU_2                   @ 0x32*8+2;
volatile sbit PT5PU_3                   @ 0x32*8+3;
volatile sbit PT1PD_3                   @ 0x32*8+4;
volatile sbit PT5PU_5                   @ 0x32*8+5;
volatile sbit PT5PU_6                   @ 0x32*8+6;
volatile sbit PT5PU_7                   @ 0x32*8+7;

//-------------------------------------------------------
//  PT5CON register bit map
//-------------------------------------------------------
volatile sbit PT5CON_0                  @ 0x33*8+0;
volatile sbit PT5CON_1                  @ 0x33*8+1;
volatile sbit PT5CON_2                  @ 0x33*8+2;
volatile sbit PT5CON_3                  @ 0x33*8+3;
volatile sbit PT5CON_5                  @ 0x33*8+5;
volatile sbit PT5CON_6                  @ 0x33*8+6;
volatile sbit PT5CON_7                  @ 0x33*8+7;

//-------------------------------------------------------
//  SRADCON0 register bit map
//-------------------------------------------------------
volatile sbit SRADCKS_0                 @ 0x34*8+0;
volatile sbit SRADCKS_1                 @ 0x34*8+1;
volatile sbit SRADACKS_0                @ 0x34*8+4;
volatile sbit SRADACKS_1                @ 0x34*8+5;
volatile sbit SARVCMSEL                 @ 0x34*8+6;
volatile sbit ADC2V_EN                  @ 0x34*8+7;

//-------------------------------------------------------
//  SRADCON1 register bit map
//-------------------------------------------------------
volatile sbit VREFS_0                   @ 0x35*8+0;
volatile sbit VREFS_1                   @ 0x35*8+1;
volatile sbit OFFEX                     @ 0x35*8+2;
volatile sbit ENOV                      @ 0x35*8+3;
volatile sbit CALIF                     @ 0x35*8+4;
volatile sbit OFTEN                     @ 0x35*8+5;
volatile sbit SRADS                     @ 0x35*8+6;
volatile sbit SRADEN                    @ 0x35*8+7;

//-------------------------------------------------------
//  SRADCON2 register bit map
//-------------------------------------------------------
volatile sbit SAR_DIFFEN                @ 0x36*8+0;
volatile sbit CHS_0                     @ 0x36*8+4;
volatile sbit CHS_1                     @ 0x36*8+5;
volatile sbit CHS_2                     @ 0x36*8+6;
volatile sbit CHS_3                     @ 0x36*8+7;

//-------------------------------------------------------
//  SRADL register bit map
//-------------------------------------------------------
volatile sbit SRAD_0                    @ 0x37*8+0;
volatile sbit SRAD_1                    @ 0x37*8+1;
volatile sbit SRAD_2                    @ 0x37*8+2;
volatile sbit SRAD_3                    @ 0x37*8+3;
volatile sbit SRAD_4                    @ 0x37*8+4;
volatile sbit SRAD_5                    @ 0x37*8+5;
volatile sbit SRAD_6                    @ 0x37*8+6;
volatile sbit SRAD_7                    @ 0x37*8+7;

//-------------------------------------------------------
//  SRADH register bit map
//-------------------------------------------------------
volatile sbit SRAD_8                    @ 0x38*8+0;
volatile sbit SRAD_9                    @ 0x38*8+1;
volatile sbit SRAD_10                   @ 0x38*8+2;
volatile sbit SRAD_11                   @ 0x38*8+3;

//-------------------------------------------------------
//  SROFTL register bit map
//-------------------------------------------------------
volatile sbit SROFT_0                   @ 0x39*8+0;
volatile sbit SROFT_1                   @ 0x39*8+1;
volatile sbit SROFT_2                   @ 0x39*8+2;
volatile sbit SROFT_3                   @ 0x39*8+3;
volatile sbit SROFT_4                   @ 0x39*8+4;
volatile sbit SROFT_5                   @ 0x39*8+5;
volatile sbit SROFT_6                   @ 0x39*8+6;
volatile sbit SROFT_7                   @ 0x39*8+7;

//-------------------------------------------------------
//  SROFTH register bit map
//-------------------------------------------------------
volatile sbit SROFT_8                   @ 0x3A*8+0;
volatile sbit SROFT_9                   @ 0x3A*8+1;
volatile sbit SROFT_10                  @ 0x3A*8+2;
volatile sbit SROFT_11                  @ 0x3A*8+3;

//-------------------------------------------------------
//  TM3R2 register bit map
//-------------------------------------------------------
volatile sbit TM3R2_0                   @ 0x3B*8+0;
volatile sbit TM3R2_1                   @ 0x3B*8+1;
volatile sbit TM3R2_2                   @ 0x3B*8+2;
volatile sbit TM3R2_3                   @ 0x3B*8+3;
volatile sbit TM3R2_4                   @ 0x3B*8+4;
volatile sbit TM3R2_5                   @ 0x3B*8+5;
volatile sbit TM3R2_6                   @ 0x3B*8+6;
volatile sbit TM3R2_7                   @ 0x3B*8+7;

//-------------------------------------------------------
//  INTF2 register bit map
//-------------------------------------------------------
volatile sbit UR0IF                     @ 0x3C*8+0;
volatile sbit I2CIF                     @ 0x3C*8+1;
volatile sbit LVDIF                     @ 0x3C*8+2;
volatile sbit TM3IF                     @ 0x3C*8+4;
volatile sbit LVRES_IF                  @ 0x3C*8+5;

//-------------------------------------------------------
//  INTE2 register bit map
//-------------------------------------------------------
volatile sbit LVDIE                     @ 0x3D*8+2;
volatile sbit TM3IE                     @ 0x3D*8+4;
volatile sbit LVRES_IE                  @ 0x3D*8+5;

//-------------------------------------------------------
//  INTCFG register bit map
//-------------------------------------------------------
volatile sbit INTCFG_0                  @ 0x40*8+0;
volatile sbit INTCFG_1                  @ 0x40*8+1;
volatile sbit INTCFG_2                  @ 0x40*8+2;
volatile sbit INTCFG_3                  @ 0x40*8+3;
volatile sbit INTCFG_4                  @ 0x40*8+4;
volatile sbit INTCFG_5                  @ 0x40*8+5;
volatile sbit INTCFG_6                  @ 0x40*8+6;
volatile sbit INTCFG_7                  @ 0x40*8+7;

//-------------------------------------------------------
//  PT1CON1 register bit map
//-------------------------------------------------------
volatile sbit PT1CON_0                  @ 0x41*8+0;

//-------------------------------------------------------
//  PT5CON1 register bit map
//-------------------------------------------------------
volatile sbit PT5W_5                    @ 0x42*8+5;
volatile sbit PT5W_6                    @ 0x42*8+6;
volatile sbit PT5W_7                    @ 0x42*8+7;

//-------------------------------------------------------
//  TM3CON3 register bit map
//-------------------------------------------------------
volatile sbit P3L2OEN                   @ 0x45*8+0;
volatile sbit P3H2OEN                   @ 0x45*8+1;
volatile sbit P3L2INV                   @ 0x45*8+2;
volatile sbit P3H2INV                   @ 0x45*8+3;
volatile sbit P3L3OEN                   @ 0x45*8+4;
volatile sbit P3H3OEN                   @ 0x45*8+5;
volatile sbit P3L3INV                   @ 0x45*8+6;
volatile sbit P3H3INV                   @ 0x45*8+7;

//-------------------------------------------------------
//  UR0_CR1 register bit map
//-------------------------------------------------------
volatile sbit UART0_EN                  @ 0x50*8+0;
volatile sbit UART0_SEL                 @ 0x50*8+1;
volatile sbit TX_EN                     @ 0x50*8+2;
volatile sbit RX_EN                     @ 0x50*8+3;
volatile sbit RX9_EN                    @ 0x50*8+4;
volatile sbit TX9_EN                    @ 0x50*8+5;
volatile sbit RX9D                      @ 0x50*8+6;
volatile sbit TX9D                      @ 0x50*8+7;

//-------------------------------------------------------
//  UR0_BRR0 register bit map
//-------------------------------------------------------
volatile sbit BRR0_0                    @ 0x51*8+0;
volatile sbit BRR0_1                    @ 0x51*8+1;
volatile sbit BRR0_2                    @ 0x51*8+2;
volatile sbit BRR0_3                    @ 0x51*8+3;
volatile sbit BRR0_4                    @ 0x51*8+4;
volatile sbit BRR0_5                    @ 0x51*8+5;
volatile sbit BRR0_6                    @ 0x51*8+6;
volatile sbit BRR0_7                    @ 0x51*8+7;

//-------------------------------------------------------
//  UR0_BRR1 register bit map
//-------------------------------------------------------
volatile sbit BRR1_0                    @ 0x52*8+0;
volatile sbit BRR1_1                    @ 0x52*8+1;
volatile sbit BRR1_2                    @ 0x52*8+2;
volatile sbit BRR1_3                    @ 0x52*8+3;
volatile sbit UARTDIV_0                 @ 0x52*8+4;
volatile sbit UARTDIV_1                 @ 0x52*8+5;
volatile sbit UARTDIV_2                 @ 0x52*8+6;

//-------------------------------------------------------
//  UR0_TX_REG register bit map
//-------------------------------------------------------
volatile sbit TX_REG_0                  @ 0x53*8+0;
volatile sbit TX_REG_1                  @ 0x53*8+1;
volatile sbit TX_REG_2                  @ 0x53*8+2;
volatile sbit TX_REG_3                  @ 0x53*8+3;
volatile sbit TX_REG_4                  @ 0x53*8+4;
volatile sbit TX_REG_5                  @ 0x53*8+5;
volatile sbit TX_REG_6                  @ 0x53*8+6;
volatile sbit TX_REG_7                  @ 0x53*8+7;

//-------------------------------------------------------
//  UR0_RX_REG register bit map
//-------------------------------------------------------
volatile sbit RX_REG_0                  @ 0x54*8+0;
volatile sbit RX_REG_1                  @ 0x54*8+1;
volatile sbit RX_REG_2                  @ 0x54*8+2;
volatile sbit RX_REG_3                  @ 0x54*8+3;
volatile sbit RX_REG_4                  @ 0x54*8+4;
volatile sbit RX_REG_5                  @ 0x54*8+5;
volatile sbit RX_REG_6                  @ 0x54*8+6;
volatile sbit RX_REG_7                  @ 0x54*8+7;

//-------------------------------------------------------
//  UR0_ST register bit map
//-------------------------------------------------------
volatile sbit STOP_ERR                  @ 0x55*8+0;
volatile sbit RX_OV_ERR                 @ 0x55*8+1;
volatile sbit TX_BUSY                   @ 0x55*8+2;
volatile sbit RX_BUSY                   @ 0x55*8+3;
volatile sbit TXFIFO_EMPTY                @ 0x55*8+4;
volatile sbit UR_SWAP                   @ 0x55*8+5;
volatile sbit UR_RINV                   @ 0x55*8+6;
volatile sbit UR_TINV                   @ 0x55*8+7;

//-------------------------------------------------------
//  UR0_INTF register bit map
//-------------------------------------------------------
volatile sbit UR0_TEIF                  @ 0x56*8+0;
volatile sbit UR0WK_IF                  @ 0x56*8+1;
volatile sbit UR0_RNIF                  @ 0x56*8+2;
volatile sbit UR0_RHIF                  @ 0x56*8+3;
volatile sbit UR0ERRIF                  @ 0x56*8+4;

//-------------------------------------------------------
//  UR0_INTE register bit map
//-------------------------------------------------------
volatile sbit UR0_TEIE                  @ 0x57*8+0;
volatile sbit UR0WK_IE                  @ 0x57*8+1;
volatile sbit UR0_RNIE                  @ 0x57*8+2;
volatile sbit UR0_RHIE                  @ 0x57*8+3;
volatile sbit UR0ERRIE                  @ 0x57*8+4;

//-------------------------------------------------------
//  I2CCON register bit map
//-------------------------------------------------------
volatile sbit I2CSTUS_0                 @ 0x59*8+0;
volatile sbit I2CSTUS_1                 @ 0x59*8+1;
volatile sbit I2CSTUS_2                 @ 0x59*8+2;
volatile sbit I2CSTUS_3                 @ 0x59*8+3;
volatile sbit ACK_EN                    @ 0x59*8+4;
volatile sbit CST_EN                    @ 0x59*8+5;
volatile sbit AWK_EN                    @ 0x59*8+6;
volatile sbit I2C_EN                    @ 0x59*8+7;

//-------------------------------------------------------
//  I2CCON1 register bit map
//-------------------------------------------------------
volatile sbit I2C_DIV_0                 @ 0x5A*8+0;
volatile sbit I2C_DIV_1                 @ 0x5A*8+1;
volatile sbit I2C_SEL                   @ 0x5A*8+7;

//-------------------------------------------------------
//  I2CDAT register bit map
//-------------------------------------------------------
volatile sbit I2CDAT_0                  @ 0x5B*8+0;
volatile sbit I2CDAT_1                  @ 0x5B*8+1;
volatile sbit I2CDAT_2                  @ 0x5B*8+2;
volatile sbit I2CDAT_3                  @ 0x5B*8+3;
volatile sbit I2CDAT_4                  @ 0x5B*8+4;
volatile sbit I2CDAT_5                  @ 0x5B*8+5;
volatile sbit I2CDAT_6                  @ 0x5B*8+6;
volatile sbit I2CDAT_7                  @ 0x5B*8+7;

//-------------------------------------------------------
//  I2CADR register bit map
//-------------------------------------------------------
volatile sbit GC_EN                     @ 0x5C*8+0;
volatile sbit I2CADR_0                  @ 0x5C*8+1;
volatile sbit I2CADR_1                  @ 0x5C*8+2;
volatile sbit I2CADR_2                  @ 0x5C*8+3;
volatile sbit I2CADR_3                  @ 0x5C*8+4;
volatile sbit I2CADR_4                  @ 0x5C*8+5;
volatile sbit I2CADR_5                  @ 0x5C*8+6;
volatile sbit I2CADR_6                  @ 0x5C*8+7;

//-------------------------------------------------------
//  I2C_INTF register bit map
//-------------------------------------------------------
volatile sbit I2C_STIF                  @ 0x5D*8+5;
volatile sbit I2C_RIF                   @ 0x5D*8+6;
volatile sbit I2C_TIF                   @ 0x5D*8+7;

//-------------------------------------------------------
//  I2C_INTE register bit map
//-------------------------------------------------------
volatile sbit I2C_STIE                  @ 0x5E*8+5;
volatile sbit I2C_RIE                   @ 0x5E*8+6;
volatile sbit I2C_TIE                   @ 0x5E*8+7;

//-------------------------------------------------------
//  ISPCON1 register bit map
//-------------------------------------------------------
volatile sbit ISPOF                     @ 0x60*8+0;
volatile sbit ISPWDTRF                  @ 0x60*8+6;

//-------------------------------------------------------
//  WRPRT register bit map
//-------------------------------------------------------
volatile sbit WRPRTF                    @ 0x63*8+0;

//-------------------------------------------------------
//  TBLPEN register bit map
//-------------------------------------------------------
volatile sbit TBLPEN_0                  @ 0x77*8+0;
volatile sbit TBLPEN_1                  @ 0x77*8+1;
volatile sbit TBLPEN_2                  @ 0x77*8+2;
volatile sbit TBLPEN_3                  @ 0x77*8+3;
volatile sbit TBLPEN_4                  @ 0x77*8+4;
volatile sbit TBLPEN_5                  @ 0x77*8+5;
volatile sbit TBLPEN_6                  @ 0x77*8+6;
volatile sbit TBLPEN_7                  @ 0x77*8+7;

//-------------------------------------------------------
//  METCH register bit map
//-------------------------------------------------------
volatile sbit METCH0                    @ 0x79*8+0;
volatile sbit MCK1_0                    @ 0x79*8+1;
volatile sbit MCK1_1                    @ 0x79*8+2;
volatile sbit METCH3                    @ 0x79*8+3;

//-------------------------------------------------------
//  CONFLASH register bit map
//-------------------------------------------------------
volatile sbit CONFLASH_0                @ 0x7C*8+0;
volatile sbit CONFLASH_1                @ 0x7C*8+1;
volatile sbit CONFLASH_2                @ 0x7C*8+2;
volatile sbit CONFLASH_3                @ 0x7C*8+3;
volatile sbit CONFLASH_4                @ 0x7C*8+4;
volatile sbit CONFLASH_5                @ 0x7C*8+5;

//-------------------------------------------------------
//  TESTOP register bit map
//-------------------------------------------------------
volatile sbit TMOD_0                    @ 0x7E*8+0;
volatile sbit TMOD_1                    @ 0x7E*8+1;
volatile sbit TMOD_2                    @ 0x7E*8+2;
volatile sbit TMOD_3                    @ 0x7E*8+3;

