﻿//============================================
// filename: main.c
// chip    : CS8M32x
// author  :
// date    : 2023-07-26
//============================================
#include "CS8M320.h"
#include "timer2.h"

/*-------------------------------Timer2 Demo例程介绍-------------------------------
可配置的初始化测试模式：mode
（1） mode = 0，测试Timer3普通计数功能：
       计数器溢出时PT1.0电平翻转，芯片工作时用示波器抓取PT1.0电平信号，校验Timer计数周期。
（2） mode = 1，测试正常PWM模式下IO输出PWM信号功能：
       配置PT5.0做Timer2 PWM输出，芯片工作时用示波器抓取PT5.0电平信号，校验PWM周期和占空比。
       用户可改配PWM输出口、周期、占空比。
（3） mode = 2，测试蜂鸣器输出功能：
       配置PT5.0做Timer2蜂鸣器输出，芯片工作时用示波器抓取PT5.0电平信号，校验PWM周期。
---------------------------------------------------------------------------------*/

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(TM2IF && TM2IE)    //4ms中断
	{
		TM2IF = 0;
		PT1_0 = ~PT1_0;
	}
}

//============================================
// program start
//============================================
void main()
{
	unsigned char mode = 0;
	GIE = 0;
	timer2_init();	//时钟为cpuclk/32，62.5KHz
	PWM2STALL = 0;	//ICD调试stall（例如单步）时，定时器2单端PWM输出低电平，此配置取决于外围硬件情况，用于在芯片调试暂停时保护外围硬件不会受损
	switch(mode)
	{
		case 0:		//计数器模式
		{
			PT1EN_0 = 1;	//PT1.0为数字输出口，无上拉
			PT1PU_0 = 0;
			PT1CON_0 = 0;
			PT1_0 = 0;
			
			T2OUT = 0;		//不做PWM/蜂鸣器输出
			PWM2OUT = 0;
			
			timer2_set_pwm_period(TIMER2_COUNT);	//4ms溢出一次
		}break;
		
		case 1:		//普通PWM模式
		{		
			PT5EN_0 = 1;	//PT5.0为PWM2输出口,数字输出口，无上拉
			PT5PU_0 = 0;
			PT5CON_0 = 0;
			
			T2OUT = 0;		//PWM2输出
			PWM2OUT = 1;
			PWM2PO = 0;		//PT5.0为PWM2输出口
			
			timer2_set_pwm_period(TIMER2_COUNT);	//频率为250Hz
			timer2_set_pwm_duty(TIMER2_PWM_DUTY_50);	//占空比为50%
		}break;
		
		case 2:		//蜂鸣器模式
		{
			PT5EN_0 = 1;	//PT5.0为蜂鸣器输出口,数字输出口，无上拉
			PT5PU_0 = 0;
			PT5CON_0 = 0;
			
			T2OUT = 1;		//蜂鸣器输出
			PWM2OUT = 0;
			PWM2PO = 0;     //PT5.0为蜂鸣器输出口
			
			T2RATE_0 = 0;
			T2RATE_1 = 0;
			T2RATE_2 = 1;
			T0SEL_0 = 1;
			T0SEL_1 = 0;   //时钟修改为MCK/16，2MHz

			timer2_set_pwm_period(TIMER2_COUNT);	//8KHZ/2=4KHz
		}break;

		default:mode = 0;
	}
	timer2_count_clr();		//清零计数器
	timer2_enable();	//使能定时器2
	timer2_int_enable();	//使能定时器2中断
	while(1);
}
