﻿/**********************************
* @file timer3.c
* @brief
* @author
* @version V0.0.0
* @date 2023.07.26
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CS8M320.h"
#include "timer3.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void timer3_init(void)
* @brief  PWM output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void timer3_init(void);

/***********************************
* @fn  timer3_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/
void timer3_pwm_period(unsigned int period);


/***********************************
* @fn  timer3_dt_time(unsigned char dt_time)
* @brief set timer3 dt time
* @param[out] none.
* @param[in] dt_time.
* @return none.
************************************/
void timer3_dt_time(unsigned char dt_time);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  void timer3_init(void)
* @brief  PWM output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void timer3_init(void)
{
	timer3_clk_source();	//CKT3的分频时钟 cpuclk 2MHZ
	timer3_div_32();		//CPUCLK/32，62.5KHz
}

/***********************************
* @fn  timer3_set_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/

void timer3_pwm_period(unsigned int period)
{
    unsigned int periodbuf[2]={0};
    periodbuf[0] = (unsigned int)(period >> 8);
	periodbuf[1] = (unsigned int)(period & 0x00ff);
    TM3INH = periodbuf[0];
    TM3IN = periodbuf[1];
}

/***********************************
* @fn  timer3_dt_time(unsigned char dt_time)
* @brief set timer3 dt time
* @param[out] none.
* @param[in] dt_time.
* @return none.
************************************/
void timer3_dt_time(unsigned char dt_time)
{
	TM3CON2 &= 0xC7;   //死区时间清零
	dt_time &= 0x07;
	dt_time <<= 3;
	TM3CON2 |= dt_time; //写入死区时间
}
	
	