﻿/**********************************
* @file timer3.h
* @brief
* @author
* @version V0.0.0
* @date 2023.07.26
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _TIMER3_H
#define  _TIMER3_H 

/* Includes 
------------------------------------------------------------------*/
#include "CS8M320.h"

/* Fuction Define -----------------------------------------------------------*/
/**
* @def TIMER3_COUNT
* @brief define TIMER3 COUNT
* Details.
*/
#define TIMER3_COUNT        (250-1) 

/**
* @def TIMER3_PWM_DUTY_50
* @brief define pwm  duty
* Details.
*/
#define TIMER3_PWM_DUTY_50       (125-1)

/**
* @def TIMER3_DT_TIME
* @brief define TIMER3 DT TIME
* Details.
*/
#define TIMER3_DT_TIME        2

/* Fuction Define -----------------------------------------------------------*/

/**
* @def timer3_enable()
* @brief set timer3 enable
* Details.
*/
#define timer3_enable()     {T3EN = 1;}

/**
* @def timer3_div_32()
* @brief set timer3 div 32
* Details.
*/
#define timer3_div_32()          {T3RATE_0 = 1;T3RATE_1 = 0;T3RATE_2 = 1;}

/**
* @def timer3_clk_source()  
* @brief timer3 clock source select
* Details.
*/
#define timer3_clk_source()        {T0SEL_0 = 0;T0SEL_1 = 0;}

/**
* @def timer3_count_clr()  
* @brief timer3 count clear
* Details.
*/
#define timer3_count_clr()        {T3RSTB = 0;}

/**
* @def timer3_dt_enable()
* @brief set timer3 dt enable
* Details.
*/
#define timer3_dt_enable()          {DT3_EN = 1;}

/**
* @def timer3_dt_clk()
* @brief set timer3 dt clock select
* Details.
*/
#define timer3_dt_clk()          {DT3CK_0 = 0; DT3CK_1 = 1;}

/**
* @def timer3_int_enable()  
* @brief enable timer3 int 
* Details.
*/
#define timer3_int_enable()       {TM3IF = 0; TM3IE = 1;GIE = 1;}


/* Exported functions 
--------------------------------------------------------*/

extern void timer3_init(void);
extern void timer3_pwm_period(unsigned int period);
extern void timer3_dt_time(unsigned char dt_time);

#endif