﻿/**********************************
* @file uart.c
* @brief
* @author
* @version V0.0.0
* @date 2023.07.26
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/
#include "CS8M320.h"
#include "uart.h"

//==============================================================	
//  发送和接收UART程序                                                    
//==============================================================

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void uart_init(void)
* @brief  uart init .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void uart_init(void);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  void uart_init(void)
* @brief uart init .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void uart_init(void)
{
	MCK = 0b00000010;   //CPU时钟为4MHZ
	UR0_BRR0 = 208;		//波特率为38400，计算方式为8M/208.3
	UR0_BRR1 = 3;
	uart_clk_div();		//串口时钟为8MHz
	TX9_EN = 0;			//不发送和接收第9位
	RX9_EN = 0;
	TX_EN = 1;			//使能发送和接收
	RX_EN = 1;
	UR_TINV = 0;		//UART输入和输出信号不取反
	UR_RINV = 0;
	UART0_SEL = 0;		//PT3.2为RX，PT3.1为TX
	UR0_INTE = 0;		//使能UART中断
	GIE = 1;
	UART0_EN = 1;		//打开UART
}