﻿/**********************************
* @file wdt.h
* @brief
* @author
* @version V0.0.0
* @date 2023.07.26
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _WDT_H
#define  _WDT_H 

/* Includes 
------------------------------------------------------------------*/
#include "CS8M320.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def  WDT_COUNT 
* @brief define 16ms wdt cnt
* Details.
*/
#define WDT_COUNT    (0xFF)

/* Fuction Define -----------------------------------------------------------*/

/**
* @def wdt_enable()  
* @brief enable wdt
* Details.
*/
#define wdt_enable()       {WDTEN = 1;}

/**
* @def wdt_clk_div()  
* @brief wdt clk div 4
* Details.
*/
#define wdt_clk_div()        {WTS_0 = 0;WTS_1 = 1;WTS_2 = 1;}

/**
* @def wdt_clk_enable()  
* @brief enable wdt clk
* Details.
*/
#define wdt_clk_enable()   {CST_WDT = 0;}

/**
* @def wdt_clk_enable()  
* @brief set 32ms wdt count
* Details.
*/
#define wdt_set_count()    {WDTIN = WDT_COUNT;}

/* Exported functions 
--------------------------------------------------------*/

extern void wdt_init(void);


#endif