﻿;============================================
; filename: csu32m10_cmp.asm
; chip    : CSU32M10
; author  :
; date    : 2019-04-25
;============================================
include "CSU32M10.inc"

count_temp  equ  0x80
;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends
 
delay_uS:                   
	nop
 	movlw 38
	movwf count_temp
loop_delay:
	nop
	decfsz count_temp,1
	goto  loop_delay	
	return
;============================================
; main program 
;============================================ 
Prog_Start: 
    bcf PT3EN,PT3EN_3
  	bsf PT3CON,PT3EN_3 ;set PT3.3 anlog input
  	bcf PT3EN,PT3EN_4
  	bsf PT3CON,PT3EN_4 ;set PT3.4 anlog input
  	bsf PT3EN,PT3EN_1
  	bsf PT3,PT3_1
  	movlw 0x00
  	movwf CMPCON2  ;set CMPEN control CMP enable
  	movlw 0x84
  	movwf CMPCON1
loop_main:
test_pt34_input:
    bcf CMPCON1,CMPVTHEN
    movlw 0x80
  	movwf CMPCON0  ;PT3.4 input
	call  delay_uS
	goto test_2v_input
test_2v_input: 
	bcf CMPCON1,CMPVTHEN
    movlw 0x82
  	movwf CMPCON0 ;2V input
	call  delay_uS
	goto test_pt34_vref_input
test_pt34_vref_input:
 	bsf CMPCON1,CMPVTHEN
    movlw 0x80
  	movwf CMPCON0
  	bsf CMPCON1,CMPVTHS_0
  	bcf CMPCON1,CMPVTHS_1  ;PT3.4-200mV input
	call  delay_uS
	goto test_vdd_vref_input
test_vdd_vref_input:
    bsf CMPCON1,CMPVTHEN
    movlw 0x90
  	movwf CMPCON0
  	bsf CMPCON1,CMPVTHS_0
  	bcf CMPCON1,CMPVTHS_1 ;vdd-200mV input
	call  delay_uS
	goto loop_main
.end