﻿;============================================
; filename: csu32m10_eeprom.asm
; chip    : CSU32M10
; author  :
; date    : 2019-04-25
;============================================
include "CSU32M10.inc"

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends
 
;============================================
; main program 
;============================================ 
Prog_Start: 
write_data1:
    movlw 00H
    movwf EADRL
    movlw 20H
    movwf EADRH  ;set write address
    bcf INTE,GIE ; disable intterupt
    movlw 96H
    movwf WRPRT
    movlw 69H
    movwf WRPRT
    movlw 5AH
    movwf WRPRT ; unlock write fuction
    btfss WRPRT,WRPRTF 
    goto $-1
    movlw 10H ;write data 
    tblp 0H
    nop
    nop
    btfss ISPCON1,CHKRSLT
    goto write_data1
write_data2:
    movlw 01H
    movwf EADRL
    movlw 20H
    movwf EADRH ;set write address
    bcf INTE,GIE ; disable intterupt
    movlw 96H
    movwf WRPRT
    movlw 69H
    movwf WRPRT
    movlw 5AH 
    movwf WRPRT ; unlock write fuction
    btfss WRPRT,WRPRTF
    goto $-1
    movlw 11H  ;write data 
    tblp 0H
    nop
    nop
    btfss ISPCON1,CHKRSLT
    goto write_data2
write_data3:
    movlw 02H
    movwf EADRL
    movlw 20H
    movwf EADRH  ;set write address
    bcf INTE,GIE ; disable intterupt
    movlw 96H
    movwf WRPRT
    movlw 69H
    movwf WRPRT
    movlw 5AH
    movwf WRPRT ; unlock write fuction
    btfss WRPRT,WRPRTF
    goto $-1
    movlw 55H  ;write data 
    tblp 0H
    nop
    nop
    btfss ISPCON1,CHKRSLT
    goto write_data3
write_data4:
    movlw 03H
    movwf EADRL
    movlw 20H
    movwf EADRH  ;set write address
    bcf INTE,GIE ; disable intterupt
    clrwdt ;clear wdt count
    nop
    nop
    nop
    movlw 96H
    movwf WRPRT
    movlw 69H
    movwf WRPRT
    movlw 5AH
    movwf WRPRT  ; unlock write fuction
    btfss WRPRT,WRPRTF
    goto $-1
    movlw 0AAH ;write data 
    tblp 0H
    nop
    nop
    btfss ISPCON1,CHKRSLT
    goto write_data4    
   	goto $						; loop forever
.end