﻿;============================================
; filename: csu32m10_lcd.asm
; chip    : CSU32M10
; author  :
; date    : 2019-03-12
;============================================
include "CSU32M10.inc"

SEG1   equ   0
SEG2   equ   1
SEG3   equ   2
SEG4   equ   3
SEG5   equ   4

COM0_VDD  macro
	bcf    PT1EN,PT1EN_6
	bsf    PT1PU,PT1PU_6
	bsf    PT1PD,PT1PD_6
	
;	bcf    PT5EN,PT5EN_0
;	bsf    PT5PU,PT5PU_0
;	bsf    PT5PD,PT5PD_0
;	
;	bcf    PT5EN,PT5EN_1
;	bsf    PT5PU,PT5PU_1
;	bsf    PT5PD,PT5PD_1

	movlw  0x0e
	movwf  LCDCOM
	bsf    PT1,PT1_4
	bsf    PT1EN,PT1EN_4
	bcf    PT1PU,PT1PU_4
	bcf    PT1PD,PT1PD_4
endm

COM0_VSS  macro
;	bcf    PT1EN,PT1EN_6
;	bsf    PT1PU,PT1PU_6
;	bsf    PT1PD,PT1PD_6
;	
;	bcf    PT5EN,PT5EN_0
;	bsf    PT5PU,PT5PU_0
;	bsf    PT5PD,PT5PD_0
;	
;	bcf    PT5EN,PT5EN_1
;	bsf    PT5PU,PT5PU_1
;	bsf    PT5PD,PT5PD_1

;	movlw  0x0e
;	movwf  LCDCOM
	bcf    PT1,PT1_4
;	bsf    PT1EN,PT1EN_4
;	bcf    PT1PU,PT1PU_4
;	bcf    PT1PD,PT1PD_4
endm

COM1_VDD  macro
;	bcf    PT1EN,PT1EN_6
;	bsf    PT1PU,PT1PU_6
;	bsf    PT1PD,PT1PD_6
;	
;	bcf    PT5EN,PT5EN_0
;	bsf    PT5PU,PT5PU_0
;	bsf    PT5PD,PT5PD_0
	
	bcf    PT1EN,PT1EN_4
	bsf    PT1PU,PT1PU_4
	bsf    PT1PD,PT1PD_4

	movlw  0x0d
	movwf  LCDCOM
	bsf    PT5,PT5_1
	bsf    PT5EN,PT5EN_1
	bcf    PT5PU,PT5PU_1
	bcf    PT5PD,PT5PD_1
endm

COM1_VSS  macro
;	bcf    PT1EN,PT1EN_6
;	bsf    PT1PU,PT1PU_6
;	bsf    PT1PD,PT1PD_6
;	
;	bcf    PT5EN,PT5EN_0
;	bsf    PT5PU,PT5PU_0
;	bsf    PT5PD,PT5PD_0
;	
;	bcf    PT1EN,PT1EN_4
;	bsf    PT1PU,PT1PU_4
;	bsf    PT1PD,PT1PD_4
;
;	movlw  0x0d
;	movwf  LCDCOM
	bcf    PT5,PT5_1
;	bsf    PT5EN,PT5EN_1
;	bcf    PT5PU,PT5PU_1
;	bcf    PT5PD,PT5PD_1
endm

COM2_VDD  macro
;	bcf    PT1EN,PT1EN_6
;	bsf    PT1PU,PT1PU_6
;	bsf    PT1PD,PT1PD_6
	
	bcf    PT5EN,PT5EN_1
	bsf    PT5PU,PT5PU_1
	bsf    PT5PD,PT5PD_1
	
;	bcf    PT1EN,PT1EN_4
;	bsf    PT1PU,PT1PU_4
;	bsf    PT1PD,PT1PD_4

	movlw  0x0b
	movwf  LCDCOM
	bsf    PT5,PT5_0
	bsf    PT5EN,PT5EN_0
	bcf    PT5PU,PT5PU_0
	bcf    PT5PD,PT5PD_0
endm

COM2_VSS  macro
;	bcf    PT1EN,PT1EN_6
;	bsf    PT1PU,PT1PU_6
;	bsf    PT1PD,PT1PD_6
;	
;	bcf    PT5EN,PT5EN_1
;	bsf    PT5PU,PT5PU_1
;	bsf    PT5PD,PT5PD_1
;	
;	bcf    PT1EN,PT1EN_4
;	bsf    PT1PU,PT1PU_4
;	bsf    PT1PD,PT1PD_4
;
;	movlw  0x0b
;	movwf  LCDCOM
	bcf    PT5,PT5_0
;	bsf    PT5EN,PT5EN_0
;	bcf    PT5PU,PT5PU_0
;	bcf    PT5PD,PT5PD_0
endm

COM3_VDD  macro
	bcf    PT5EN,PT5EN_0
	bsf    PT5PU,PT5PU_0
	bsf    PT5PD,PT5PD_0
	
;	bcf    PT5EN,PT5EN_1
;	bsf    PT5PU,PT5PU_1
;	bsf    PT5PD,PT5PD_1
;	
;	bcf    PT1EN,PT1EN_4
;	bsf    PT1PU,PT1PU_4
;	bsf    PT1PD,PT1PD_4

	movlw  0x07
	movwf  LCDCOM
	bsf    PT1,PT1_6
	bsf    PT1EN,PT1EN_6
	bcf    PT1PU,PT1PU_6
	bcf    PT1PD,PT1PD_6
endm

COM3_VSS  macro
;	bcf    PT5EN,PT5EN_0
;	bsf    PT5PU,PT5PU_0
;	bsf    PT5PD,PT5PD_0
;	
;	bcf    PT5EN,PT5EN_1
;	bsf    PT5PU,PT5PU_1
;	bsf    PT5PD,PT5PD_1
;	
;	bcf    PT1EN,PT1EN_4
;	bsf    PT1PU,PT1PU_4
;	bsf    PT1PD,PT1PD_4
;
;	movlw  0x07
;	movwf  LCDCOM
	bcf    PT1,PT1_6
;	bsf    PT1EN,PT1EN_6
;	bcf    PT1PU,PT1PU_6
;	bcf    PT1PD,PT1PD_6
endm

single_number   equ 0x80
ten_number      equ 0x81
hundred_number  equ 0x82
number          equ 0x83
scanning_count  equ 0x84
scanning_flag   equ 0x85
number_temp     equ 0x86
search_temp     equ 0x87
single_display  equ 0x88
ten_display     equ 0x89
hundred_display equ 0x8a

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:
	push
tm0_int:
	btfss INTF,TM0IF
	goto  tm2_int
	bcf   INTF,TM0IF
	movlw  100 
	subwf  number,0
	btfsc STATUS,C
	goto  int_number
	goto  add_number
int_number:
	clrf   number
	goto   split_number
add_number:
	movlw 1
	addwf number,1
split_number:
	clrf   hundred_number
	clrf   ten_number
	clrf   single_number
	movfw  number
	movwf  number_temp
split_loop:
	movlw  10
	subwf  number_temp,1
	btfsc STATUS,C
	goto  add_ten
	goto  add_single
add_ten:
	incf   ten_number,1
	movlw  10
	subwf  ten_number,0
	btfss  STATUS,C
	goto   split_loop
	clrf   ten_number
	movlw  1
	movwf  hundred_number
	clrf  scanning_count
	goto   end_int
add_single:
	movlw  10
	addwf  number_temp,0
	movwf  single_number
	clrf  scanning_count	
	goto  end_int
tm2_int:
	btfss INTF,TM2IF
	goto  end_int
	bcf   INTF,TM2IF
	bsf   scanning_flag,0    
	goto  end_int
end_int:
	pop
	retfie
.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	bcf    PT1EN,PT1EN_6
	bsf    PT1PU,PT1PU_6
	bsf    PT1PD,PT1PD_6
	
	bcf    PT1EN,PT1EN_4
	bsf    PT1PU,PT1PU_4
	bsf    PT1PD,PT1PD_4

	bcf    PT5EN,PT5EN_1
	bsf    PT5PU,PT5PU_1
	bsf    PT5PD,PT5PD_1
	
	bcf    PT5EN,PT5EN_0
	bsf    PT5PU,PT5PU_0
	bsf    PT5PD,PT5PD_0
	
	bcf   MCK,CST_WDT           ;open wdt clk
	movlw 0x72
	movwf TM0CON                ;ckt0=wdt_clk
	movlw 249
	movwf TM0IN                 ;(249+1)/(32KHz/128)=1S
	bsf   TM0CON,T0EN           ;enable timer0
	bsf   INTE,TM0IE            ;enable timer0 interrupt
	
	bsf    METCH,T2RATE_3      ;ckt0 = MCK
	movlw  0x70
	movwf  TM2CON
	movlw  0
	movwf  TM2INH 
	movlw  249
	movwf  TM2IN                ; (249+1)/(16MHz/128)=2mS	
	bsf   TM2CON,T2EN           ;enable timer2
	bsf   INTE,TM2IE            ;enable timer2 interrupt
	bsf   INTE,GIE              ;enable interrupt
	
	clrf   number
	clrf   hundred_number
	clrf   ten_number
	clrf   single_number
	clrf   scanning_count
	clrf   PT3
	movlw  0x1f
	movwf  PT3EN
main:
	btfss   scanning_flag,0      ;2ms
	goto    main
	bcf     scanning_flag,0
	
	bcf     INTE,GIE
	movfw   single_number
	movwf   search_temp
	call    search_table
	movwf   single_display
	movfw   ten_number
	movwf   search_temp
	call    search_table
	movwf   ten_display	
	movfw   hundred_number
	movwf   hundred_display
	bsf     INTE,GIE

scanningtable:
	movfw scanning_count
	addpcw
	goto com0_vdd_scan
	goto com0_vss_scan
	goto com1_vdd_scan
	goto com1_vss_scan
	goto com2_vdd_scan
	goto com2_vss_scan
	goto com3_vdd_scan
	goto com3_vss_scan
com0_vdd_scan:
	movlw  0x1f
	movwf  PT3
	COM0_VDD
	btfsc ten_display,4
	bcf   PT3,SEG2
	btfsc ten_display,0
	bcf   PT3,SEG1
	btfsc single_display,4
	bcf   PT3,SEG4
	btfsc single_display,0
	bcf   PT3,SEG3	
	goto  add_scanning_count
com0_vss_scan:
	movlw  0x00
	movwf  PT3
	COM0_VSS
	btfsc ten_display,4
	bsf   PT3,SEG2
	btfsc ten_display,0
	bsf   PT3,SEG1
	btfsc single_display,4
	bsf   PT3,SEG4
	btfsc single_display,0
	bsf   PT3,SEG3	
	goto  add_scanning_count
com1_vdd_scan:
	movlw  0x1f
	movwf  PT3
	COM1_VDD
	btfsc ten_display,5
	bcf   PT3,SEG2
	btfsc ten_display,1
	bcf   PT3,SEG1
	btfsc single_display,5
	bcf   PT3,SEG4
	btfsc single_display,1
	bcf   PT3,SEG3	
	goto  add_scanning_count
com1_vss_scan:
	movlw  0x00
	movwf  PT3
	COM1_VSS
	btfsc ten_display,5
	bsf   PT3,SEG2
	btfsc ten_display,1
	bsf   PT3,SEG1
	btfsc single_display,5
	bsf   PT3,SEG4
	btfsc single_display,1
	bsf   PT3,SEG3	
	goto  add_scanning_count
com2_vdd_scan:
	movlw  0x1f
	movwf  PT3
	COM2_VDD
	btfsc ten_display,6
	bcf   PT3,SEG2
	btfsc ten_display,2
	bcf   PT3,SEG1
	btfsc single_display,6
	bcf   PT3,SEG4
	btfsc single_display,2
	bcf   PT3,SEG3	
	goto  add_scanning_count
com2_vss_scan:
	movlw  0x00
	movwf  PT3
	COM2_VSS
	btfsc ten_display,6
	bsf   PT3,SEG2
	btfsc ten_display,2
	bsf   PT3,SEG1
	btfsc single_display,6
	bsf   PT3,SEG4
	btfsc single_display,2
	bsf   PT3,SEG3	
	goto  add_scanning_count
com3_vdd_scan:
	movlw  0x1f
	movwf  PT3
	COM3_VDD
	bcf   PT3,SEG3           ;display %
	btfsc hundred_display,0
	bcf   PT3,SEG1	
	btfsc ten_display,7
	bcf   PT3,SEG2
	btfsc ten_display,3
	bcf   PT3,SEG1
	btfsc single_display,7
	bcf   PT3,SEG4
	btfsc single_display,3
	bcf   PT3,SEG3	
	goto  add_scanning_count
com3_vss_scan:
	movlw  0x00
	movwf  PT3
	COM3_VSS	
	bsf   PT3,SEG3           ;display %
	btfsc hundred_display,0
	bsf   PT3,SEG1	
	btfsc ten_display,7
	bsf   PT3,SEG2
	btfsc ten_display,3
	bsf   PT3,SEG1
	btfsc single_display,7
	bsf   PT3,SEG4
	btfsc single_display,3
	bsf   PT3,SEG3	
	goto  add_scanning_count
add_scanning_count:
	incf scanning_count,1
	movlw  8
	subwf  scanning_count,0
	btfsc STATUS,C
	clrf   scanning_count
	goto main
	
search_table:
	movfw   search_temp
	addpcw
	retlw  0xf5
	retlw  0x60
	retlw  0xb6
	retlw  0xf2
	retlw  0x63
	retlw  0xd3
	retlw  0xd7
	retlw  0x70
	retlw  0xf7
	retlw  0xf3
.end