﻿;============================================
; filename: csu32m10_sleep.asm
; chip    : CSU32M10
; author  :
; date    : 2019-02-26
;============================================
include "CSU32M10.inc"

;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:
	push
	btfsc INTF,E1IF
	bcf   INTF,E1IF
	pop
	retfie
.ends
 
;============================================
; main program 
;============================================ 
Prog_Start:  
	clrf PT1
	movlw 0xF7           ;pt1.3 in
	movwf PT1EN
	movlw 0x08
	movwf PT1PU
	clrf  PT1PD
	movlw 0x14           ;enable int1  pt1.3
	movwf PT1CON
	
	clrf PT3
	movlw 0x3f
	movwf PT3EN
	clrf PT3PU
	clrf PT3PD
	clrf PT3CON

	clrf PT5
	movlw 0x03
	movwf PT5EN
	clrf PT5PU
	clrf PT5PD
	clrf PT5CON
	
	clrf TM0CON
	clrf TM2CON
	clrf TM3CON
	clrf SRADCON1
	bsf MCK,5                   ;disable wdt clk
check_sleep:
	btfss PT1,PT1_3 
	goto  $-1
	clrf INTF
	movlw 0x82
	movwf INTE
	
	sleep
	nop
	clrf INTE
	goto check_sleep			
.end