﻿;============================================
; filename: csu32m10_table.asm
; chip    : CSU32M10
; author  :
; date    : 2019-03-12
;============================================
include "CSU32M10.inc"

CSCC_Variable   .section ram,addr=0x80
R_Tabaddr_H			ds	1			;High-level address
R_Tabaddr_L			ds	1	        ;Low-level address
R_Data_H			ds	1			;High-level Data
R_Data_L			ds	1	        ;Low-level Data
.ends
;============================================
; program start
;============================================ 
CSCC_RES_VECT   .section rom,addr=0x00   
	goto     Prog_Start      	; go to main program
.ends

;============================================
; interrupt vector table
;============================================
CSCC_INT_VECT	.section rom,addr=0x04 
    goto     INT_FUNCTION		; go to interrupt function
.ends

;============================================
; interrupt function
;============================================
INT_FUNCTION_sec .section rom	;
INT_FUNCTION:

.ends

;TabStartAddr  dw   0x0001,0x0012,0x0123,0x1234     ;System allocation address

TabHeaderData .section ROM, addr=0x0700	       ;designated address
TabStartAddr:
	dw		0x0001,0x0012,0x0123,0x1234
.ends
;============================================
; main program 
;============================================ 
Prog_Start:  
	movlw	LOW TabStartAddr                                                                         
	movwf	R_Tabaddr_L                                                             
	movlw	HIGH TabStartAddr                                                                         
	movwf	R_Tabaddr_H                 ;StartAddr
Sub_Read_Tab0:
	movfw	R_Tabaddr_L                                                                         
	movwf	EADRL                                                             
	movfw	R_Tabaddr_H                                                                        
	movwf	EADRH                       ;StartAddr+0
	movp								;read                       
	nop                                                                                 
	movwf	R_Data_L                    ;Low-level data is stored in Work       
	movfw	EDATH                       ;High-level data is stored in EDATH                                                
	movwf	R_Data_H
	
Sub_Read_Tab1:
	movlw   1
	addwf   R_Tabaddr_L,1
	movlw   0
	addwfc  R_Tabaddr_H,1
	movfw	R_Tabaddr_L                                                                         
	movwf	EADRL                                                             
	movfw	R_Tabaddr_H                                                                        
	movwf	EADRH                       ;StartAddr+1
	movp								;read                       
	nop                                                                                 
	movwf	R_Data_L                    ;Low-level data is stored in Work       
	movfw	EDATH                       ;High-level data is stored in EDATH                                                
	movwf	R_Data_H	
	
Sub_Read_Tab2:
	movlw   1
	addwf   R_Tabaddr_L,1
	movlw   0
	addwfc  R_Tabaddr_H,1
	movfw	R_Tabaddr_L                                                                         
	movwf	EADRL                                                             
	movfw	R_Tabaddr_H                                                                        
	movwf	EADRH                       ;StartAddr+2
	movp								;read                       
	nop                                                                                 
	movwf	R_Data_L                    ;Low-level data is stored in Work       
	movfw	EDATH                       ;High-level data is stored in EDATH                                                
	movwf	R_Data_H
	
Sub_Read_Tab3:
	movlw   1
	addwf   R_Tabaddr_L,1
	movlw   0
	addwfc  R_Tabaddr_H,1
	movfw	R_Tabaddr_L                                                                         
	movwf	EADRL                                                             
	movfw	R_Tabaddr_H                                                                        
	movwf	EADRH                       ;StartAddr+3
	movp								;read                       
	nop                                                                                 
	movwf	R_Data_L                    ;Low-level data is stored in Work       
	movfw	EDATH                       ;High-level data is stored in EDATH                                                
	movwf	R_Data_H
	
	goto $						        ; loop forever
.end