﻿/**********************************
* @file main.c
* @brief
* @author
* @version V0.1.0
* @date 2019.04.08
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"


/* Fuction Declare ----------------------------------------------------------*/

unsigned char adc_offset_data = 0; 
unsigned char adc_offset_data_temp = 0;
static void delay_us(void);
/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

static void delay_us(void)
{
  unsigned int j;
  for(j = 1000;j > 0;j--);
}
/***********************************
* @fn   INT_FUNCTION(void) interrupt
* @brief interrupt service funcion.
* @param[out] 
* @param[in] 
* @return 
************************************/

void INT_FUNCTION(void) interrupt
{

}

/***********************************
* @fn  main()
* @brief main function
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void main()
{
  unsigned char i = 0;
  asm ("MOVLW 0F0H");
  asm ("MOVWF _EADRH"); 
  asm ("MOVLW 03H");
  asm ("MOVWF _EADRL"); 
  asm ("MOVP"); // read adc offset
  asm ("NOP");
  asm ("MOVWF _SROFTL"); //store adc offset in SROFTL
  asm ("MOVLW 00H");
  asm ("MOVWF _SROFTH");
  adc_offset_data = SROFTL; // get adc offset
  PT1EN_0 = 1;
  PT1EN_1 = 1;
  PT1_0 = 0;
  PT1_1 = 0;
  while(1)
  {
      switch(i)
      {
         case 0: {
                   adc_offset_data_temp = adc_offset_data>>7;
                   adc_offset_data_temp = adc_offset_data_temp & 0x01;// read adc offset bit7
                   i++;
                 }break;
         case 1:{
                   adc_offset_data_temp = adc_offset_data>>6;
                   adc_offset_data_temp = adc_offset_data_temp & 0x01;// read adc offset bit6
                   i++;
                }break;
         case 2:{
                   adc_offset_data_temp = adc_offset_data>>5;
                   adc_offset_data_temp = adc_offset_data_temp & 0x01;// read adc offset bit5
                   i++;
                }break;
         case 3:{
                   adc_offset_data_temp = adc_offset_data>>4;
                   adc_offset_data_temp = adc_offset_data_temp & 0x01;// read adc offset bit4
                   i++;
                }break;
         case 4:{
                   
                   adc_offset_data_temp = adc_offset_data>>3;
                   adc_offset_data_temp = adc_offset_data_temp & 0x01;// read adc offset bit3
                   i++;
                }break;
         case 5:{
                   adc_offset_data_temp = adc_offset_data>>2;
                   adc_offset_data_temp = adc_offset_data_temp & 0x01;// read adc offset bit2
                   i++;
                }break;
         case 6:{
                   adc_offset_data_temp = adc_offset_data>>1;
                   adc_offset_data_temp = adc_offset_data_temp & 0x01;// read adc offset bit1
                   i++;
                }break;
         case 7:{
                   adc_offset_data_temp = adc_offset_data & 0x01;// read adc offset bit0
                   i++;
                }break;
        default: {i = 0;}break;
      }
       PT1_0 = ~PT1_0; //set pt1.0 as clock bus
       if(adc_offset_data_temp == 1)
       {
         PT1_1 = 1; // set pt1.1 as data bus
       }
       else
       {
         PT1_1 = 0;
       } 
       delay_us();
       if(i > 7)
       {
         i = 0;
         delay_us();
         delay_us();
         delay_us();
       }
  }
}
