﻿/**********************************
* @file csu32p20_cmp.h
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _CSU32M10_CMP_H
#define  _CSU32M10_CMP_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU32M10.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def csu32m10_cmp_select_enable_mode() 
* @brief select CMPEN enable cmp
  param[in] 
* Details.
*/
#define csu32m10_cmp_select_enable_mode()   {CMPENS_0 = 0;CMPENS_1 = 0;}

/**
* @def csu32m10_cmp_enable() 
* @brief enable cmp
  param[in] 
* Details.
*/
#define csu32m10_cmp_enable()   {CMPEN = 1;}
 
/**
* @def csu32m10_cmp_disable() 
* @brief disable cmp
  param[in] 
* Details.
*/
#define csu32m10_cmp_disable()   {CMPEN = 0;}

/**
* @def csu32m10_cmp_result_output_en() 
* @brief PT3.1 output cmp result  
  param[in] 
* Details.
*/
#define csu32m10_cmp_result_output_en()   {CMPOEN = 1;}

/**
* @def csu32m10_cmp_vref_enble()
* @brief enable vref
  param[in] 
* Details.
*/
#define csu32m10_cmp_inside_vref_enble()   {CMPVTHEN = 1;}

/**
* @def csu32m10_cmp_set_inside_PT34()
* @brief set pt3.4 as inside vref
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_inside_PT34()   {CMP_PSEL = 0;}

/**
* @def csu32m10_cmp_set_outside_PT34()
* @brief set pt3.4 as vref
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_outside_PT34()   {CMP_NSEL_0 = 0;CMP_NSEL_1 = 0;CMP_NSEL_2 = 0;}

/**
* @def csu32m10_cmp_set_outside_2v()
* @brief set pt3.4 as vref
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_outside_2v()   {CMP_NSEL_0 = 1;CMP_NSEL_1 = 0;CMP_NSEL_2 = 0;}
/**
* @def csu32m10_cmp_set_inside_vdd()
* @brief set vdd as inside vref
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_inside_vdd()   {CMP_PSEL = 1;}

/**
* @def csu32m10_cmp_vref_disable() 
* @brief disable inside vref
  param[in] 
* Details.
*/
#define csu32m10_cmp_inside_vref_disable()   {CMPVTHEN = 0;}

/**
* @def csu32m10_cmp_vref_enble()
* @brief set vref 80mv
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_vref_80mv()   {CMPVTHS_0 = 0;CMPVTHS_1 = 0;}

/**
* @def csu32m10_cmp_set_vref_200mv()
* @brief set vref 200mv
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_vref_200mv()  {CMPVTHS_0 = 1;CMPVTHS_1 = 0;}

/**
* @def csu32m10_cmp_set_vref_200mv()
* @brief set vref 320mv
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_vref_320mv()  {CMPVTHS_0 = 0;CMPVTHS_1 = 1;}

/**
* @def csu32m10_cmp_set_vref_200mv()
* @brief set vref 320mv
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_vref_480mv()  {CMPVTHS_0 = 1;CMPVTHS_1 = 1;}

/**
* @def csu32m10_cmp_set_flit_time()
* @brief set flit time 16 instruction cycle
  param[in] 
* Details.
*/
#define csu32m10_cmp_set_flit_time()  {CMP_FLT_0 = 0;CMP_FLT_1 = 0;CMP_FLT_2 = 1;}

/* Exported functions 
--------------------------------------------------------*/

extern void csu32m10_cmp_init(void);
extern void csu32m10_cmp_result_output(void);



#endif