﻿/**********************************
* @file csu32m10_cmp.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.03
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_cmp.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  csu32m10_cmp_init(void)
* @brief CMP init.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_cmp_init(void);

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
static void delay_us(void);

/***********************************
* @fn  csu32m10_cmp_result_output(void)
* @brief cmp result output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_cmp_result_output(void);

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

static void delay_us(void)
{
  unsigned int j;
  for(j = 1000;j > 0;j--);
}

/***********************************
* @fn  csu32m10_cmp_init(void)
* @brief CMP init.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_cmp_init(void)
{
  PT3EN_3 = 0; 
  PT3CON_3 = 1; //set PT3.3 analog input
  PT3EN_4 = 0;
  PT3CON_4 = 1; //set PT3.4 analog input
  PT3EN_1 = 1;
  PT3_1 = 0;
  csu32m10_cmp_select_enable_mode(); //set CMPEN control CMP enable
  csu32m10_cmp_result_output_en();
  csu32m10_cmp_set_flit_time();  
}

/***********************************
* @fn  csu32m10_cmp_result_output(void)
* @brief cmp result output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_cmp_result_output(void)
{
  static unsigned char i = 0;
     switch(i)
     {
        case 0:{
                  csu32m10_cmp_inside_vref_disable();
                  csu32m10_cmp_set_outside_PT34(); //PT3.4 input
                  csu32m10_cmp_enable();
                  i++;
                  delay_us();
               }break;
        case 1:{
                  csu32m10_cmp_inside_vref_disable();
                  csu32m10_cmp_set_outside_2v(); //2V input
                  i++;
                  delay_us();
               }break;
        case 2:{
                 csu32m10_cmp_inside_vref_enble();
                 csu32m10_cmp_set_vref_200mv(); // PT3.4-200mv input
                 csu32m10_cmp_set_inside_PT34();
                 i++;
                 delay_us(); 
               }break;
        case 3:{
                 csu32m10_cmp_inside_vref_enble(); 
                 csu32m10_cmp_set_vref_200mv(); // vdd-200mv input
                 csu32m10_cmp_set_inside_vdd();
                 i = 0;
                 delay_us(); 
               }break;    
      default: {i = 0;}break;
     }
}

