﻿/**********************************
* @file csu32m10_halt.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.03
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_halt.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  csu32m10_timer0_init(void)
* @brief 1s count initialize .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_timer0_init(void);

/***********************************
* @fn  csu32m10_halt_demo(void)
* @brief halt mode test
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_halt_demo(void);

/***********************************
* @fn  csu32m10_timer0_init(void)
* @brief 1s count initialize .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_timer0_init(void)
{
  wdt_clk_enable(); //enable 32K clk
  timer0_set_wdtclk(); // set 32K wdt clk as CKT0
  timer0_clk_div_128(); 
  timer0_div_128_1s(); // (249+1)/(32KHz/128)=1S
  timer0_int_flag_clr();  
  timer0_int_enable(); // enable timer0 int
  timer0_count_clr();  // clr timer0 count
  timer0_count_start(); // timer0 start count 
}

/***********************************
* @fn  csu32m10_halt_demo(void)
* @brief halt mode test
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_halt_demo(void)
{
  PT1EN_1 = 1; // set PT1.1 output mode
  PT1_1 = 1;
  csu32m10_timer0_init();
  while(1)
  {
    PT1_1 = 0;
    asm("halt"); //enter halt mode
    PT1_1 = 1;
  }  
}

