﻿/**********************************
* @file main.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.08
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_lcd.h"
#include "csu32m10_timer.h"

/* Fuction Declare ----------------------------------------------------------*/

unsigned char time_2ms_flag = 0;
disp_base_t    display_base;

//lcd num: 0,1,2,3,4,5,6,7,8,9 
const unsigned char num_select_table[]  = {0x3f,0x06,0x5b,0x4f,0x66,0x6d,0x7d,0x07,0x7f,0x6f};

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn   INT_FUNCTION(void) interrupt
* @brief interrupt service funcion.
* @param[out] 
* @param[in] 
* @return 
************************************/

void INT_FUNCTION(void) interrupt
{
  if(TM0IF)
  {
    TM0IF = 0;
    display_base.num++;
    display_base.unit = display_base.num%10;  // get unit
    display_base.tens = display_base.num%100/10;  // get tens 
    display_base.hundreds = display_base.num/100; //get hundreds
    if(display_base.num >=100)
    {
      display_base.num = 0;
    }
  }
  else if(TM2IF)
  {
    TM2IF = 0; 
    time_2ms_flag = 1;
  }
}

/***********************************
* @fn  main()
* @brief main function
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void main()
{
  csu32m10_lcd_init();
  while(1)
  {
    if(time_2ms_flag)  //62.5HZ
    {
      time_2ms_flag = 0;
      display_base.unit_temp = num_select_table[display_base.unit];
      display_base.tens_temp = num_select_table[display_base.tens];
      display_base.hundreds_temp = display_base.hundreds;
      switch(display_base.com_scan)
      {
        case COM0_VDD_SCAN: {
                              PT3 = 0x1f; // set seg all output vdd
                              csu32m10_lcd_com0_vdd_drive();
                              display_base.tens_display = (display_base.tens_temp>>5)&0x01; //get 1F
                              if(display_base.tens_display) //judge display 1F or not
                              {
                                LCD_SEG0 = 0;  
                              }
                              else
                              {
                                LCD_SEG0 = 1;
                              }
                              display_base.tens_display = (display_base.tens_temp)&0x01; //get 1A
                              if(display_base.tens_display) //judge display 1A or not
                              {
                                LCD_SEG1 = 0;
                              }
                              else
                              {
                                LCD_SEG1 = 1;
                              }
                              display_base.unit_display = (display_base.unit_temp>>5)&0x01; //get 2F
                              if(display_base.unit_display) //judge display 2F or not
                              {
                                LCD_SEG2 = 0;
                              }
                              else
                              {
                                LCD_SEG2 = 1;
                              }
                              display_base.unit_display = (display_base.unit_temp)&0x01; // get 2A
                              if(display_base.unit_display) //judge display 2A or not 
                              {
                                LCD_SEG3 = 0;
                              }
                              else
                              {
                                LCD_SEG3 = 1;
                              }
                              display_base.com_scan = COM0_VSS_SCAN;
                            }break;
        case COM0_VSS_SCAN: {
                              PT3 = 0x00; // set seg all output 0
                              csu32m10_lcd_com0_vss_drive();
                              display_base.tens_display = (display_base.tens_temp>>5)&0x01;
                              if(display_base.tens_display)
                              {
                                LCD_SEG0 = 1;
                              }
                              else
                              {
                                LCD_SEG0 = 0;
                              }
                              display_base.tens_display = (display_base.tens_temp)&0x01;
                              if(display_base.tens_display)
                              {
                                LCD_SEG1 = 1;
                              }
                              else
                              {
                                LCD_SEG1 = 0;
                              }
                              display_base.unit_display = (display_base.unit_temp>>5)&0x01;
                              if(display_base.unit_display)
                              {
                                LCD_SEG2 = 1;
                              }
                              else
                              {
                                LCD_SEG2 = 0;
                              }
                              display_base.unit_display = (display_base.unit_temp)&0x01;
                              if(display_base.unit_display)
                              {
                                LCD_SEG3 = 1;
                              }
                              else
                              {
                                LCD_SEG3 = 0;
                              }
                              display_base.com_scan = COM1_VDD_SCAN;
                            }break;
        case COM1_VDD_SCAN: {
                              PT3 = 0x1f; // set seg all output vdd
                              csu32m10_lcd_com1_vdd_drive();
                              display_base.tens_display = (display_base.tens_temp>>6)&0x01;// get 1G
                              if(display_base.tens_display)// judge display 1G or not
                              {
                                LCD_SEG0 = 0;
                              }
                              else
                              {
                                LCD_SEG0 = 1;
                              }
                              display_base.tens_display = (display_base.tens_temp>>1)&0x01;// get 1B
                              if(display_base.tens_display) // judge display 1B or not
                              {
                                LCD_SEG1 = 0;
                              }
                              else
                              {
                                LCD_SEG1 = 1;
                              }
                              display_base.unit_display = (display_base.unit_temp>>6)&0x01; //get 2G
                              if(display_base.unit_display) // judge display 2G or not
                              {
                                LCD_SEG2 = 0;
                              }
                              else
                              {
                                LCD_SEG2 = 1;
                              }
                              display_base.unit_display = (display_base.unit_temp>>1)&0x01; // get 2B
                              if(display_base.unit_display) // judge display 2G or not
                              {
                                LCD_SEG3 = 0;
                              }
                              else
                              {
                                LCD_SEG3 = 1;
                              }
                              display_base.com_scan = COM1_VSS_SCAN;
                           }break;
       case COM1_VSS_SCAN: {
                              PT3 = 0x00; // set seg all output vss
                              csu32m10_lcd_com1_vss_drive();
                              display_base.tens_display = (display_base.tens_temp>>6)&0x01;
                              if(display_base.tens_display)
                              {
                                LCD_SEG0 = 1;
                              }
                              else
                              {
                                LCD_SEG0 = 0;
                              }
                              display_base.tens_display = (display_base.tens_temp>>1)&0x01;
                              if(display_base.tens_display)
                              {
                                LCD_SEG1 = 1;
                              }
                              else
                              {
                                LCD_SEG1 = 0;
                              }
                              display_base.unit_display = (display_base.unit_temp>>6)&0x01;
                              if(display_base.unit_display)
                              {
                                LCD_SEG2 = 1;
                              }
                              else
                              {
                                LCD_SEG2 = 0;
                              }
                              display_base.unit_display = (display_base.unit_temp>>1)&0x01;
                              if(display_base.unit_display)
                              {
                                LCD_SEG3 = 1;
                              }
                              else
                              {
                                LCD_SEG3 = 0;
                              }
                              display_base.com_scan = COM2_VDD_SCAN;
                           }break;
       case COM2_VDD_SCAN: {
                              PT3 = 0x1f; // set seg all output vdd
                              csu32m10_lcd_com2_vdd_drive();
                              display_base.tens_display = (display_base.tens_temp>>4)&0x01;// get 1E
                              if(display_base.tens_display) // judge display 1E or not
                              {
                                LCD_SEG0 = 0;
                              }
                              else
                              {
                                LCD_SEG0 = 1;
                              }
                              display_base.tens_display = (display_base.tens_temp>>2)&0x01; //get 1C
                              if(display_base.tens_display) // judge display 1C or not
                              {
                                LCD_SEG1 = 0;
                              }
                              else
                              {
                                LCD_SEG1 = 1;
                              }
                              display_base.unit_display = (display_base.unit_temp>>4)&0x01; // get 2E
                              if(display_base.unit_display) // judge display 2E or not
                              {
                                LCD_SEG2 = 0;
                              }
                              else
                              {
                                LCD_SEG2 = 1;
                              }
                              display_base.unit_display = (display_base.unit_temp>>2)&0x01; // get 2C
                              if(display_base.unit_display) // judge display 2C or not
                              {
                                LCD_SEG3 = 0;
                              }
                              else
                              {
                                LCD_SEG3 = 1;
                              }
                              display_base.com_scan = COM2_VSS_SCAN;
                           }break;
       case COM2_VSS_SCAN: {
                              PT3 = 0x00; // set seg all output vss
                              csu32m10_lcd_com2_vss_drive();
                              display_base.tens_display = (display_base.tens_temp>>4)&0x01;
                              if(display_base.tens_display)
                              {
                                LCD_SEG0 = 1;
                              }
                              else
                              {
                                LCD_SEG0 = 0;
                              }
                              display_base.tens_display = (display_base.tens_temp>>2)&0x01;
                              if(display_base.tens_display)
                              {
                                LCD_SEG1 = 1;
                              }
                              else
                              {
                                LCD_SEG1 = 0;
                              }
                              display_base.unit_display = (display_base.unit_temp>>4)&0x01;
                              if(display_base.unit_display)
                              {
                                LCD_SEG2 = 1;
                              }
                              else
                              {
                                LCD_SEG2 = 0;
                              }
                              display_base.unit_display = (display_base.unit_temp>>2)&0x01;
                              if(display_base.unit_display)
                              {
                                LCD_SEG3 = 1;
                              }
                              else
                              {
                                LCD_SEG3 = 0;
                              }
                              display_base.com_scan = COM3_VDD_SCAN;
                           }break;
       case COM3_VDD_SCAN: {
                              PT3 = 0x1f; // set seg all output vdd
                              csu32m10_lcd_com3_vdd_drive();
                              display_base.hundreds_display = display_base.hundreds_temp; // get 1BC
                              if(display_base.hundreds_display) // judge display 1BC or not
                              {
                                LCD_SEG0 = 0;
                              }
                              else
                              {
                                LCD_SEG0 = 1;
                              }
                              display_base.tens_display = (display_base.tens_temp>>3)&0x01; // get 1D
                              if(display_base.tens_display) // judge display 1D or not
                              {
                                LCD_SEG1 = 0;
                              }
                              else
                              {
                                LCD_SEG1 = 1;
                              }
                              LCD_SEG2 = 0; // display %
                              display_base.unit_display = (display_base.unit_temp>>3)&0x01;// get 2D
                              if(display_base.unit_display) // judge display 2D or not
                              {
                                LCD_SEG3 = 0;
                              }
                              else
                              {
                                LCD_SEG3 = 1;
                              }
                              display_base.com_scan = COM3_VSS_SCAN;
                           }break;
       case COM3_VSS_SCAN: {
                              PT3 = 0x00; // set seg all output vss
                              csu32m10_lcd_com3_vss_drive();
                              display_base.hundreds_display = display_base.hundreds_temp;
                              if(display_base.hundreds_display)
                              {
                                LCD_SEG0 = 1;
                              }
                              else
                              {
                                LCD_SEG0 = 0;
                              }
                              display_base.tens_display = (display_base.tens_temp>>3)&0x01;
                              if(display_base.tens_display)
                              {
                                LCD_SEG1 = 1;
                              }
                              else
                              {
                                LCD_SEG1 = 0;
                              }
                              LCD_SEG2 = 1;
                              display_base.unit_display = (display_base.unit_temp>>3)&0x01;
                              if(display_base.unit_display)
                              {
                                LCD_SEG3 = 1;
                              }
                              else
                              {
                                LCD_SEG3 = 0;
                              }
                              display_base.com_scan = COM0_VDD_SCAN;
                           }break;
           default:       { display_base.com_scan = COM0_VDD_SCAN;}break;
      
      
      }
    
    }
  }
}
