﻿/**********************************
* @file main.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_timer0.h"

/* Fuction Declare ----------------------------------------------------------*/

unsigned char timer0_8ms_cnt = 0;  

/* Fuction Define -----------------------------------------------------------*/


/***********************************
* @fn   INT_FUNCTION(void) interrupt
* @brief interrupt service funcion.
* @param[out] 
* @param[in] 
* @return 
************************************/

void INT_FUNCTION(void) interrupt
{
   if(TM0IF == 1)
   {
     TM0IF = 0;// clr timer0 interrupt flag
     if(++timer0_8ms_cnt >= CNT_8MS)
     {
       timer0_8ms_cnt = 0;
       PT1_0 = ~PT1_0;
     }  
   }
}

/***********************************
* @fn  main()
* @brief main function
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void main()
{
  PT1EN_0 = 1; //set io output mode
  csu32m10_timer0_init();
  while(1);
}
