﻿/**********************************
* @file csu32m10_timer2.h
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _CSU32M10_TIMER2_H
#define  _CSU32M10_TIMER2_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU32M10.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def TIMER2_PWM_PERIOD
* @brief define pwm period
* Details.
*/
#define TIMER2_PWM_PERIOD        (2500-1)  //50HZ 

/**
* @def TIMER2_PWM_DUTY_20
* @brief define pwm 20% duty
* Details.
*/
#define TIMER2_PWM_DUTY_20       (500-1)   //20%

/**
* @def TIMER2_PWM_DUTY_80 
* @brief define pwm 80% period
* Details.
*/
#define TIMER2_PWM_DUTY_80       (2000-1)  //80% 

/**
* @def TIMER2_PWM_OUT_IO
* @brief output io select
* Details.
*/
#define TIMER2_PWM_OUT_IO         1  // PT5.0 output:1 PT3.0 output:0


/* Fuction Define -----------------------------------------------------------*/

/**
* @def timer2_set_pwm_mode()
* @brief set timer2 as pwm mode
* Details.
*/
#define timer2_set_pwm_mode()     {T2OUT = 0;PWM2OUT = 1;}

/**
* @def timer2_set_mck()
* @brief set timer2 clk
* Details.
*/
#define timer2_set_mck()          {T2RATE_3 = 1;}

/**
* @def timer2_div_128()
* @brief set timer2 div 128
* Details.
*/
#define timer2_div_128()          {T2RATE_0 = 1;T2RATE_1 = 1;T2RATE_2 = 1;}

/**
* @def timer2_pwm_enable()
* @brief enable pwm output
* Details.
*/
#define timer2_pwm_enable()       {PWM2OUT = 1;}

/**
* @def timer2_pwm_start() 
* @brief pwm cnt start
* Details.
*/
#define timer2_pwm_start()        {T2EN = 1;}

/**
* @def timer2_int_enable()  
* @brief enable timer2 int 
* Details.
*/
#define timer2_int_enable()       {TM2IE = 1;GIE = 1;}

/**
* @def timer2_count_clr()  
* @brief timer2 count clr
* Details.
*/
#define timer2_count_clr()        {T2RSTB = 0;}

/* Exported functions 
--------------------------------------------------------*/

extern void csu32m10_timer2_pwm_init(void);
extern void csu32m10_timer2_set_pwm_period(unsigned int period);
extern void csu32m10_timer2_set_pwm_duty(unsigned int duty);


#endif