﻿/**********************************
* @file csu32m10_timer2.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32M10.h"
#include "csu32m10_timer2.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void csu32m10_timer2_pwm_init(void)
* @brief  PWM output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32m10_timer2_pwm_init(void);

/***********************************
* @fn  csu32m10_timer2_set_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/
void csu32m10_timer2_set_pwm_period(unsigned int period);

/***********************************
* @fn  csu32m10_timer2_set_pwm_duty(unsigned int duty)
* @brief set pwm duty
* @param[out] none.
* @param[in] pwm duty.
* @return none.
************************************/
void csu32m10_timer2_set_pwm_duty(unsigned int duty);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  csu32m10_timer2_set_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/

void csu32m10_timer2_set_pwm_period(unsigned int period)
{
    unsigned int periodbuf[2]={0};
    periodbuf[0] = (unsigned int)(period >> 8);
	periodbuf[1] = (unsigned int)(period&0x00ff);
    TM2INH = periodbuf[0];
    TM2IN = periodbuf[1];
}

/***********************************
* @fn  csu32m10_timer2_set_pwm_duty(unsigned int duty)
* @brief set pwm duty
* @param[out] none.
* @param[in] pwm duty.
* @return none.
************************************/

void csu32m10_timer2_set_pwm_duty(unsigned int duty)
{
    unsigned int dutybuf[2]={0};
    dutybuf[0] = (unsigned int)(duty >> 8);
	dutybuf[1] = (unsigned int)(duty&0x00ff);
    TM2RH = dutybuf[0];
    TM2R = dutybuf[1];
}

/***********************************
* @fn  void csu32m10_timer2_pwm_init(void)
* @brief  PWM output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32m10_timer2_pwm_init(void)
{
  if(TIMER2_PWM_OUT_IO)
  {
    PT5EN_0 = 1; //set PT5.0 output mode
    PWM2PO = 0; //PT5.0 output pwm
  }
  else
  {
    PT3EN_1 = 1; //set PT3.1 output mode
    PWM2PO = 1; //PT3.1 output pwm
  }
  timer2_set_pwm_mode(); //set timer2 pwm mode
  timer2_set_mck();// set mck as timer2 clk
  timer2_div_128(); 
  csu32m10_timer2_set_pwm_period(TIMER2_PWM_PERIOD); //set PWM period:50HZ
  csu32m10_timer2_set_pwm_duty(TIMER2_PWM_DUTY_20); // set PWM duty:20%
  timer2_pwm_enable();
  timer2_int_enable();     
  timer2_count_clr();
  timer2_pwm_start(); 
}


