﻿/**********************************
* @file csu32m10_wdt.h
* @brief
* @author
* @version V0.0.0
* @date 2019.04.08
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _CSU32M10_WDT_H
#define  _CSU32M10_WDT_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU32M10.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def  WDT_COUNT 
* @brief define 16ms wdt cnt
* Details.
*/
#define WDT_COUNT 0xff

/* Fuction Define -----------------------------------------------------------*/

/**
* @def wdt_enable()  
* @brief enable wdt
* Details.
*/
#define wdt_enable()       {WDTEN = 1;}

/**
* @def wdt_div_2()  
* @brief wdt div 2
* Details.
*/
#define wdt_div_2()        {WTS_0 = 1;WTS_1 = 1;WTS_2 = 1;}

/**
* @def wdt_clk_enable()  
* @brief enable wdt clk
* Details.
*/
#define wdt_clk_enable()   {CST_WDT = 0;}

/**
* @def wdt_clk_enable()  
* @brief set 16ms wdt count
* Details.
*/
#define wdt_set_count()    {WDTIN = WDT_COUNT;}

/* Exported functions 
--------------------------------------------------------*/

extern void csu32m10_wdt_init(void);
extern void csu32m10_clr_wdt(void);


#endif