﻿/**********************************
* @file csu32m10_wwdt.h
* @brief
* @author
* @version V0.0.0
* @date 2019.04.08
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _CSU32M10_WWDT_H
#define  _CSU32M10_WWDT_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU32M10.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def WWDT_COUNT  
* @brief define wwdt cnt 
* Details.
*/
#define WWDT_COUNT    0x7f


/**
* @def WWDT_RATE  
* @brief define wwdt window rate 
* Details.
*/
#define WWDT_RATE     0x5e

/* Fuction Define -----------------------------------------------------------*/

/**
* @def wwdt_enable()  
* @brief enable wwdt 
* Details.
*/
#define wwdt_enable()      {WWDTEN = 1;}

/**
* @def wwdt_set_count()  
* @brief set wwdt count
* Details.
*/
#define wwdt_set_count()   {WWDTCR = WWDT_COUNT;}

/**
* @def wwdt_set_rate()  
* @brief set wwdt window rate
* Details.
*/
#define wwdt_set_rate()    {WWDTWR = WWDT_RATE;}

/* Exported functions 
--------------------------------------------------------*/

extern void csu32m10_wwdt_init(void);



#endif