﻿/**********************************
* @file csu32p20_timer.c
* @brief
* @author
* @version V0.0.0
* @date 2019.04.01
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU32P20.h"
#include "csu32p20_timer.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  csu32p20_timer0_init(void)
* @brief 1s count initialize .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32p20_timer0_init(void);

/***********************************
* @fn  void csu32p20_timer2_init(void)
* @brief 2ms count initialize .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void csu32p20_timer2_init(void);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  csu32p20_timer0_init(void)
* @brief 1s count initialize .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32p20_timer0_init(void)
{
  wdt_clk_enable();
  timer0_set_wdtclk(); // set 32K wdt clk as CKT0
  timer0_clk_div_128(); 
  timer0_div_128_1s(); // (249+1)/(32KHz/128)=1S
  timer0_int_flag_clr();  
  timer0_int_enable(); // enable timer0 int
  timer0_count_clr();  // clr timer0 count
  timer0_count_start(); // timer0 start count 
}


/***********************************
* @fn  void csu32p20_timer2_init(void)
* @brief 2ms count initialize .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void csu32p20_timer2_init(void)
{
  timer2_set_mck();// set mck as timer2 clk
  timer2_div_128(); 
  timer2_div_128_2ms(); //(249+1)/(16MHz/128)=2mS
  timer2_int_flag_clr();
  timer2_int_enable();     
  timer2_count_clr();
  timer2_count_start(); 
}

